/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFCallable;
import org.pepstock.jem.io.BytesArray;

public class RemoteOutputStream
extends OutputStream {
    private boolean appendDueToBuffer = false;
    private File file = null;
    private boolean append = false;
    private static final int BUFFER_SIZE = 4096;
    private BytesArray buffer = new BytesArray(4096);
    private JPPFTask task = null;

    public RemoteOutputStream(JPPFTask task, File file, boolean append) {
        this.task = task;
        this.file = file;
        this.append = append;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public JPPFTask getTask() {
        return this.task;
    }

    public void setTask(JPPFTask task) {
        this.task = task;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.size() == 0) {
            return;
        }
        try {
            this.task.compute((JPPFCallable)new WriteBytesOutput(this.file, this.append, this.buffer, this.appendDueToBuffer));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.appendDueToBuffer = true;
        this.buffer = new BytesArray(4096);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer.size() + len > 4096) {
            this.flush();
        }
        this.buffer.write(b, off, len);
    }

    public static class WriteBytesOutput
    implements JPPFCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private File file = null;
        private boolean append = false;
        private BytesArray buffer = null;
        private boolean appendDueToBuffer = false;

        public WriteBytesOutput(File file, boolean append, BytesArray buffer, boolean appendDueToBuffer) {
            this.buffer = buffer;
            this.file = file;
            this.append = append;
            this.appendDueToBuffer = appendDueToBuffer;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public boolean isAppend() {
            return this.append;
        }

        public void setAppend(boolean append) {
            this.append = append;
        }

        public BytesArray getBuffer() {
            return this.buffer;
        }

        public void setBuffer(BytesArray buffer) {
            this.buffer = buffer;
        }

        public Boolean call() {
            OutputStream ostream = null;
            try {
                ostream = this.append ? new FileOutputStream(this.file, true) : (this.appendDueToBuffer ? new FileOutputStream(this.file, true) : new FileOutputStream(this.file));
                this.buffer.writeTo(ostream);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            finally {
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return Boolean.TRUE;
        }
    }
}

