/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFCallable;
import org.pepstock.jem.io.BytesArray;
import org.pepstock.jem.jppf.ChunkDefinition;
import org.pepstock.jem.jppf.ChunksFactory;

public class RemoteInputStream
extends InputStream {
    private File file = null;
    private BytesArray buffer = null;
    private JPPFTask task = null;
    private LinkedList<ChunkDefinition> chunks = null;
    private int chunkIndex = 0;
    private ChunkDefinition currentChunk = null;
    private int index = 0;
    private int position = 0;
    private int size = 0;

    public RemoteInputStream(JPPFTask task, File file) throws IOException {
        this.task = task;
        this.file = file;
        try {
            this.chunks = (LinkedList)task.compute((JPPFCallable)new GetChunks(file));
            for (ChunkDefinition chunk : this.chunks) {
                this.size += chunk.getLength();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JPPFTask getTask() {
        return this.task;
    }

    public void setTask(JPPFTask task) {
        this.task = task;
    }

    @Override
    public int read() throws IOException {
        if (this.index == 0 || this.currentChunk == null || (long)this.index > this.currentChunk.getEnd()) {
            if (this.chunkIndex == this.chunks.size()) {
                return -1;
            }
            this.currentChunk = this.chunks.get(this.chunkIndex);
            ++this.chunkIndex;
            try {
                this.buffer = (BytesArray)this.task.compute((JPPFCallable)new ReadBytesOutput(this.file, this.currentChunk));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.position = 0;
        }
        byte data = this.buffer.read(this.position);
        ++this.index;
        ++this.position;
        return data;
    }

    @Override
    public int available() throws IOException {
        return this.size;
    }

    public static class GetChunks
    implements JPPFCallable<LinkedList<ChunkDefinition>> {
        private static final long serialVersionUID = 1L;
        private File file = null;

        public GetChunks(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public LinkedList<ChunkDefinition> call() throws Exception {
            return ChunksFactory.getChunks(this.file);
        }
    }

    public static class ReadBytesOutput
    implements JPPFCallable<BytesArray> {
        private static final long serialVersionUID = 1L;
        private File file = null;
        private ChunkDefinition chunk = null;

        public ReadBytesOutput(File file, ChunkDefinition chunk) {
            this.chunk = chunk;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public BytesArray call() {
            BytesArray ba = new BytesArray(this.chunk.getLength());
            RandomAccessFile istream = null;
            try {
                istream = new RandomAccessFile(this.file, "r");
                istream.seek(this.chunk.getStart());
                byte[] buffer = new byte[this.chunk.getLength()];
                istream.read(buffer);
                ba.write(buffer, 0, this.chunk.getLength());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return ba;
        }
    }
}

