/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jppf.server.protocol.JPPFTask;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.jppf.ChunkDefinition;
import org.pepstock.jem.jppf.RemoteChunkedInputStream;
import org.pepstock.jem.jppf.RemoteInputStream;
import org.pepstock.jem.jppf.RemoteOutputStream;
import org.pepstock.jem.jppf.SizableSequenceInputStream;
import org.pepstock.jem.node.NodeMessage;

public class RemoteDataStreamFactory
implements ObjectFactory {
    private XStream xstream = new XStream();
    private JPPFTask task = null;
    private LinkedList<ChunkDefinition> chunks = null;
    private String chunkableDataDescription = null;
    private String mergedDataDescription = null;
    private String temporaryFile = null;

    @Override
    public Object getObjectInstance(Object object, Name name, Context ctx, Hashtable<?, ?> env) throws Exception {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String taskXml = this.getValue(reference, "jem.jppf.task.object");
            this.task = (JPPFTask)this.xstream.fromXML(taskXml);
            String chunksXml = this.getValue(reference, "jem.chunks.object");
            if (chunksXml != null) {
                this.chunks = (LinkedList)this.xstream.fromXML(chunksXml);
            }
            this.chunkableDataDescription = this.getValue(reference, "jem.chunkable.data.description.object");
            this.mergedDataDescription = this.getValue(reference, "jem.merged.data.description.object");
            this.temporaryFile = this.getValue(reference, "jem.temporary.file.object");
            RefAddr datastreams_a = reference.get("jem.datadescrition.object");
            DataDescriptionImpl ddImpl = (DataDescriptionImpl)this.xstream.fromXML((String)datastreams_a.getContent());
            if (ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
                if (ddImpl.getDataSetsImpl().size() > 1) {
                    ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
                    for (DataSetImpl dstream : ddImpl.getDataSetsImpl()) {
                        inputStreams.add(this.getInputStream(dstream, ctx));
                    }
                    return new SizableSequenceInputStream(inputStreams);
                }
                DataSetImpl dstream = ddImpl.getDataSetsImpl().get(0);
                if (this.chunkableDataDescription != null && ddImpl.getName().equalsIgnoreCase(this.chunkableDataDescription)) {
                    return this.getInputStream(dstream, ctx, true);
                }
                return this.getInputStream(dstream, ctx);
            }
            DataSetImpl dstream = ddImpl.getDataSetsImpl().get(0);
            if (this.mergedDataDescription != null && ddImpl.getName().equalsIgnoreCase(this.mergedDataDescription)) {
                return this.getOutputStream(ddImpl, dstream, ctx, this.temporaryFile);
            }
            return this.getOutputStream(ddImpl, dstream, ctx);
        }
        throw new Exception(NodeMessage.JEMC133E.toMessage().getFormattedMessage(object.getClass().getName()));
    }

    private InputStream getInputStream(DataSetImpl ds, Context ctx) throws Exception {
        return this.getInputStream(ds, ctx, false);
    }

    private InputStream getInputStream(DataSetImpl ds, Context ctx, boolean isChunkable) throws Exception {
        if (ds.getType() != 6) {
            if (this.chunks != null && isChunkable) {
                ChunkDefinition chunk = this.chunks.get(this.task.getPosition());
                return new RemoteChunkedInputStream(this.task, ds.getRealFile(), chunk);
            }
            return new RemoteInputStream(this.task, ds.getRealFile());
        }
        Object object = ctx.lookup(ds.getDataSource());
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        throw new Exception(NodeMessage.JEMC132E.toMessage().getFormattedMessage(ds.getDataSource()));
    }

    private OutputStream getOutputStream(DataDescriptionImpl dd, DataSetImpl ds, Context ctx) throws Exception {
        return this.getOutputStream(dd, ds, ctx, null);
    }

    private OutputStream getOutputStream(DataDescriptionImpl dd, DataSetImpl ds, Context ctx, String temporaryFile) throws Exception {
        if (ds.getType() == 2) {
            throw new Exception(NodeMessage.JEMC135E.toMessage().getMessage());
        }
        if (ds.getType() == 6) {
            Object object = ctx.lookup(ds.getDataSource());
            if (object instanceof OutputStream) {
                return (OutputStream)object;
            }
            throw new Exception(NodeMessage.JEMC134E.toMessage().getFormattedMessage(ds.getDataSource()));
        }
        if (temporaryFile != null) {
            return new RemoteOutputStream(this.task, new File(temporaryFile), false);
        }
        return new RemoteOutputStream(this.task, ds.getRealFile(), dd.getDisposition().equalsIgnoreCase("MOD"));
    }

    private String getValue(Reference reference, String key) {
        RefAddr a = reference.get(key);
        if (a != null) {
            return (String)a.getContent();
        }
        return null;
    }
}

