/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFCallable;
import org.pepstock.jem.io.BytesArray;
import org.pepstock.jem.jppf.ChunkDefinition;
import org.pepstock.jem.jppf.ChunksFactory;

public class RemoteChunkedInputStream
extends InputStream {
    private File file = null;
    private BytesArray buffer = null;
    private JPPFTask task = null;
    private LinkedList<ChunkDefinition> chunks = null;
    private int chunkIndex = 0;
    private ChunkDefinition currentChunk = null;
    private long index = 0L;
    private int position = 0;
    private int size = 0;
    private ChunkDefinition chunk = null;

    public RemoteChunkedInputStream(JPPFTask task, File file, ChunkDefinition chunk) throws IOException {
        this.task = task;
        this.file = file;
        this.chunk = chunk;
        this.index = chunk.getStart();
        try {
            this.chunks = ChunksFactory.getChunksByChunk(chunk);
            this.size = chunk.getLength();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public JPPFTask getTask() {
        return this.task;
    }

    public void setTask(JPPFTask task) {
        this.task = task;
    }

    public ChunkDefinition getChunk() {
        return this.chunk;
    }

    public void setChunk(ChunkDefinition chunk) {
        this.chunk = chunk;
    }

    @Override
    public int read() throws IOException {
        if (this.size == 0) {
            return -1;
        }
        if (this.index == this.chunk.getStart() || this.currentChunk == null || this.index > this.currentChunk.getEnd()) {
            if (this.chunkIndex == this.chunks.size()) {
                return -1;
            }
            this.currentChunk = this.chunks.get(this.chunkIndex);
            ++this.chunkIndex;
            try {
                this.buffer = (BytesArray)this.task.compute((JPPFCallable)new ReadBytesOutput(this.file, this.currentChunk));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.position = 0;
        }
        byte data = this.buffer.read(this.position);
        ++this.index;
        ++this.position;
        return data;
    }

    @Override
    public int available() throws IOException {
        return this.size;
    }

    public static class ReadBytesOutput
    implements JPPFCallable<BytesArray> {
        private static final long serialVersionUID = 1L;
        private File file = null;
        private ChunkDefinition chunk = null;

        public ReadBytesOutput(File file, ChunkDefinition chunk) {
            this.chunk = chunk;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public BytesArray call() {
            BytesArray ba = new BytesArray(this.chunk.getLength());
            RandomAccessFile istream = null;
            try {
                istream = new RandomAccessFile(this.file, "r");
                istream.seek(this.chunk.getStart());
                byte[] buffer = new byte[this.chunk.getLength()];
                istream.read(buffer, 0, this.chunk.getLength());
                ba.write(buffer, 0, this.chunk.getLength());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return ba;
        }
    }
}

