/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.pepstock.jem.jppf.ExecuteManager;
import org.pepstock.jem.jppf.JPPFBean;
import org.pepstock.jem.jppf.JPPFMessage;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.pepstock.jem.springbatch.tasks.JemTasklet;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.repeat.RepeatStatus;

public class JPPFTasklet
extends JemTasklet {
    private JPPFBean bean = null;

    public JPPFBean getBean() {
        return this.bean;
    }

    public void setBean(JPPFBean bean) {
        this.bean = bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RepeatStatus run(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        if (this.bean == null) {
            throw new Exception(JPPFMessage.JEMJ011E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (this.bean.getRunnable() == null) {
            throw new Exception(JPPFMessage.JEMJ001E.toMessage().getFormattedMessage(new Object[0]));
        }
        LogAppl.getInstance();
        InitialContext ic = ContextUtils.getContext();
        XStream xstream = new XStream();
        TypedProperties propsFromDataDescritpion = new TypedProperties();
        try {
            Object ddconfig = ic.lookup("JPPF-CONFIG");
            InputStream configInputStream = (InputStream)ddconfig;
            propsFromDataDescritpion.load(configInputStream);
        }
        catch (NamingException e) {
            // empty catch block
        }
        TypedProperties propsFromBean = this.loadProperties(this.bean);
        StepContext stepContext = chunkContext.getStepContext();
        propsFromBean.setProperty("jem.job.name", stepContext.getJobName());
        propsFromBean.setProperty("jem.task.name", stepContext.getStepName());
        if (propsFromBean.getProperty("jem.datasource") != null) {
            String datasource = propsFromBean.getProperty("jem.datasource");
            Object configResource = ic.lookup(datasource);
            if (!(configResource instanceof TypedProperties)) throw new Exception(JPPFMessage.JEMJ010E.toMessage().getFormattedMessage("jem.datasource", configResource.getClass().getName(), TypedProperties.class.getName()));
            TypedProperties props = (TypedProperties)configResource;
            JPPFConfiguration.getProperties().putAll((Map)propsFromDataDescritpion);
            JPPFConfiguration.getProperties().putAll((Map)propsFromBean);
            JPPFConfiguration.getProperties().putAll((Map)props);
        } else {
            JPPFConfiguration.getProperties().putAll((Map)propsFromDataDescritpion);
            JPPFConfiguration.getProperties().putAll((Map)propsFromBean);
        }
        String icXml = xstream.toXML((Object)ic);
        ExecuteManager.submit(icXml);
        return RepeatStatus.FINISHED;
    }

    private TypedProperties loadProperties(JPPFBean bean) throws Exception {
        String address;
        String[] addresses;
        TypedProperties props = new TypedProperties();
        props.setProperty("jppf.discovery.enabled", Boolean.FALSE.toString());
        if (bean.getAddress() != null && (addresses = StringUtils.split((String)(address = StringUtils.remove((String)bean.getAddress(), (String)" ")), (String)",")) != null && addresses.length > 0) {
            StringBuffer drivers = new StringBuffer();
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].contains(":")) {
                    throw new Exception(JPPFMessage.JEMJ008E.toMessage().getFormattedMessage(addresses[i]));
                }
                String host = StringUtils.substringBefore((String)addresses[i], (String)":");
                String port = StringUtils.substringAfter((String)addresses[i], (String)":");
                String driver = "jem" + i;
                props.setProperty(driver + ".jppf.server.port", port);
                props.setProperty(driver + ".jppf.server.host", host);
                drivers.append(driver).append(" ");
            }
            props.setProperty("jppf.drivers", drivers.toString());
        }
        if (bean.getDatasource() != null) {
            props.setProperty("jem.datasource", bean.getDatasource());
        }
        props.setProperty("jem.runnable", bean.getRunnable());
        props.setProperty("jem.task.number", String.valueOf(Math.max(1, bean.getParallelTaskNumber())));
        if (bean.getDelimiter() != null && bean.getDelimiterString() != null) {
            throw new Exception(JPPFMessage.JEMJ027E.toMessage().getFormattedMessage(new Object[0]));
        }
        if ((bean.getDelimiter() != null || bean.getDelimiterString() != null) && bean.getChunkableDataDescription() == null) {
            throw new BuildException(JPPFMessage.JEMJ013E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (bean.getChunkableDataDescription() != null) {
            this.containsDataDescription(bean.getChunkableDataDescription(), false);
            props.setProperty("jem.chunkable.data.description", bean.getChunkableDataDescription());
            if (bean.getDelimiter() != null) {
                props.setProperty("jem.delimiter", bean.getDelimiter());
            } else if (bean.getDelimiterString() != null) {
                props.setProperty("jem.delimiter.string", bean.getDelimiterString());
            }
        }
        if (bean.getMergedDataDescription() != null) {
            this.containsDataDescription(bean.getMergedDataDescription(), true);
            props.setProperty("jem.merged.data.description", bean.getMergedDataDescription());
        }
        return props;
    }

    private void containsDataDescription(String name, boolean write) throws Exception {
        boolean found = false;
        for (DataDescription ddescription : this.getDataDescriptionList()) {
            if (!ddescription.getName().equalsIgnoreCase(name)) continue;
            if (write) {
                if (ddescription.getDisposition().equalsIgnoreCase("SHR")) {
                    throw new Exception(JPPFMessage.JEMJ014E.toMessage().getFormattedMessage(name));
                }
            } else {
                if (!ddescription.getDisposition().equalsIgnoreCase("SHR")) {
                    throw new Exception(JPPFMessage.JEMJ015E.toMessage().getFormattedMessage(name));
                }
                if (ddescription.isMultiDataset()) {
                    throw new Exception(JPPFMessage.JEMJ016E.toMessage().getFormattedMessage(name));
                }
                DataSet ddataset = ddescription.getDatasets().iterator().next();
                if (ddataset.getDatasource() != null) {
                    throw new Exception(JPPFMessage.JEMJ017E.toMessage().getFormattedMessage(name));
                }
                if (ddataset.isInline()) {
                    throw new Exception(JPPFMessage.JEMJ018E.toMessage().getFormattedMessage(name));
                }
            }
            found = true;
            break;
        }
        if (!found) {
            throw new Exception(JPPFMessage.JEMJ019E.toMessage().getFormattedMessage(name));
        }
    }
}

