/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.StringRefAddr;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFJob;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.task.storage.DataProvider;
import org.jppf.task.storage.MemoryMapDataProvider;
import org.jppf.utils.JPPFConfiguration;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.jem.jppf.ChunkDefinition;
import org.pepstock.jem.jppf.ChunksFactory;
import org.pepstock.jem.jppf.DataStreamNameClassPair;
import org.pepstock.jem.jppf.JPPFMessage;
import org.pepstock.jem.jppf.RunnableTask;
import org.pepstock.jem.jppf.WrapperJPPFTask;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;
import org.pepstock.jem.node.tasks.jndi.DataStreamReference;

public class ExecuteManager {
    private static JPPFClient jppfClient = null;
    private static final LinkedList<File> temporayFiles = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void submit(String initialContext) throws Exception {
        temporayFiles.clear();
        try {
            jppfClient = new JPPFClient();
            JPPFJob job = ExecuteManager.createJob(initialContext);
            ExecuteManager.executeBlockingJob(job);
        }
        finally {
            JPPFConfiguration.getProperties().clear();
            if (jppfClient != null) {
                jppfClient.close();
            }
        }
    }

    private static JPPFJob createJob(String xmlContext) throws Exception {
        RunnableTask t;
        XStream xstream = new XStream();
        String jobName = JPPFConfiguration.getProperties().getProperty("jem.job.name");
        String taskName = JPPFConfiguration.getProperties().getProperty("jem.task.name");
        String runnable = JPPFConfiguration.getProperties().getProperty("jem.runnable");
        int parallelTaskNumber = JPPFConfiguration.getProperties().getInt("jem.task.number");
        MemoryMapDataProvider provider = new MemoryMapDataProvider();
        provider.setValue((Object)"jem.context", (Object)xmlContext);
        provider.setValue((Object)"jem.task.number", (Object)String.valueOf(parallelTaskNumber));
        if (JPPFConfiguration.getProperties().containsKey((Object)"jem.chunkable.data.description")) {
            String dataDescription = JPPFConfiguration.getProperties().getProperty("jem.chunkable.data.description");
            File file = null;
            InitialContext ic = ContextUtils.getContext();
            NamingEnumeration<NameClassPair> list = ic.list(dataDescription);
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                if (!pair.getName().equalsIgnoreCase(dataDescription) || !(pair instanceof DataStreamNameClassPair)) continue;
                DataStreamNameClassPair dsPair = (DataStreamNameClassPair)pair;
                DataStreamReference prevReference = (DataStreamReference)dsPair.getObject();
                StringRefAddr sra = (StringRefAddr)prevReference.get("jem.datadescrition.object");
                DataDescriptionImpl ddImpl = (DataDescriptionImpl)xstream.fromXML(sra.getContent().toString());
                file = ddImpl.getDataSetsImpl().iterator().next().getRealFile();
                break;
            }
            if (file == null) {
                throw new FileNotFoundException(JPPFMessage.JEMJ019E.toMessage().getFormattedMessage(dataDescription));
            }
            long bufferSize = file.length() / (long)parallelTaskNumber;
            LinkedList<ChunkDefinition> chunks = null;
            String delimiter = JPPFConfiguration.getProperties().getProperty("jem.delimiter");
            String delimiterString = JPPFConfiguration.getProperties().getProperty("jem.delimiter.string");
            if (delimiter != null) {
                char splitter = '\n';
                if (delimiter.toLowerCase().startsWith("0x")) {
                    delimiter = StringUtils.substringAfter((String)delimiter.toLowerCase(), (String)"0x");
                    splitter = (char)Integer.parseInt(delimiter, 16);
                } else {
                    splitter = StringEscapeUtils.unescapeJava((String)delimiter).charAt(0);
                }
                String displayDelimiter = Integer.toHexString((byte)splitter) + "(" + splitter + ")";
                System.out.println(JPPFMessage.JEMJ020I.toMessage().getFormattedMessage(displayDelimiter));
                chunks = ChunksFactory.getChunksByDelimiter(file, bufferSize, splitter);
                provider.setValue((Object)"jem.delimiter", (Object)Character.valueOf(splitter));
            } else if (delimiterString != null) {
                System.out.println(JPPFMessage.JEMJ020I.toMessage().getFormattedMessage(delimiterString));
                chunks = ChunksFactory.getChunksByDelimiter(file, bufferSize, delimiterString);
                provider.setValue((Object)"jem.delimiter", (Object)delimiterString);
            } else {
                chunks = ChunksFactory.getChunksByDelimiter(file, bufferSize);
            }
            parallelTaskNumber = chunks.size();
            System.out.println(JPPFMessage.JEMJ021I.toMessage().getFormattedMessage(chunks));
            provider.setValue((Object)"jem.task.number", (Object)String.valueOf(parallelTaskNumber));
            provider.setValue((Object)"jem.chunkable.data.description", (Object)dataDescription);
            provider.setValue((Object)"jem.chunks", (Object)xstream.toXML(chunks));
        }
        System.out.println(JPPFMessage.JEMJ023I.toMessage().getFormattedMessage(parallelTaskNumber));
        if (JPPFConfiguration.getProperties().containsKey((Object)"jem.merged.data.description")) {
            for (int i = 0; i < parallelTaskNumber; ++i) {
                File temp = File.createTempFile("task[" + i + "]-merge", ".jemjppf");
                temp.deleteOnExit();
                temporayFiles.add(temp);
                System.out.println(JPPFMessage.JEMJ022I.toMessage().getFormattedMessage(temp.getAbsolutePath(), i));
            }
            provider.setValue((Object)"jem.merged.data.description", (Object)JPPFConfiguration.getProperties().getProperty("jem.merged.data.description"));
            provider.setValue((Object)"jem.temporary.files", (Object)xstream.toXML(temporayFiles));
        }
        JPPFJob job = new JPPFJob((DataProvider)provider);
        job.setName(jobName + "." + taskName);
        Object clazz = Class.forName(runnable).newInstance();
        if (clazz instanceof JPPFTask) {
            for (int i = 0; i < parallelTaskNumber; ++i) {
                t = new WrapperJPPFTask((JPPFTask)clazz);
                job.addTask((Object)t, new Object[0]);
            }
        } else if (clazz instanceof Runnable) {
            for (int i = 0; i < parallelTaskNumber; ++i) {
                t = new RunnableTask((Runnable)clazz);
                job.addTask((Object)t, new Object[0]);
            }
        } else {
            throw new ClassCastException(JPPFMessage.JEMJ002E.toMessage().getFormattedMessage(runnable, Runnable.class.getName(), JPPFTask.class.getName()));
        }
        return job;
    }

    private static void executeBlockingJob(JPPFJob job) throws Exception {
        job.setBlocking(true);
        System.out.println(JPPFMessage.JEMJ003I.toMessage().getFormattedMessage(job.getName()));
        List results = jppfClient.submit(job);
        if (JPPFConfiguration.getProperties().containsKey((Object)"jem.merged.data.description")) {
            ExecuteManager.mergeExecutionResults(results);
        } else {
            ExecuteManager.processExecutionResults(results);
        }
    }

    private static void processExecutionResults(List<JPPFTask> results) throws Exception {
        Exception resultException = null;
        for (JPPFTask task : results) {
            if (task.getException() != null) {
                System.out.println(JPPFMessage.JEMJ005E.toMessage().getFormattedMessage(task.getId(), task.getException().getMessage()));
                task.getException().printStackTrace();
                resultException = task.getException();
                continue;
            }
            if (task.getResult() != null) {
                System.out.println(JPPFMessage.JEMJ006I.toMessage().getFormattedMessage(task.getId(), task.getResult()));
                continue;
            }
            System.out.println(JPPFMessage.JEMJ007I.toMessage().getFormattedMessage(task.getId()));
        }
        if (resultException != null) {
            throw resultException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeExecutionResults(List<JPPFTask> results) throws Exception {
        Collections.sort(results, new Comparator<JPPFTask>(){

            @Override
            public int compare(JPPFTask o1, JPPFTask o2) {
                return o1.getPosition() - o2.getPosition();
            }
        });
        for (JPPFTask task : results) {
            if (task.getException() == null) continue;
            System.out.println(JPPFMessage.JEMJ005E.toMessage().getFormattedMessage(task.getId(), task.getException().getMessage()));
            task.getException().printStackTrace();
            throw task.getException();
        }
        System.out.println(JPPFMessage.JEMJ024I.toMessage().getFormattedMessage(new Object[0]));
        String mergedDataDescription = JPPFConfiguration.getProperties().getProperty("jem.merged.data.description");
        InitialContext ic = ContextUtils.getContext();
        Object object = ic.lookup(mergedDataDescription);
        OutputStream os = (OutputStream)object;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            for (JPPFTask task : results) {
                File file = temporayFiles.get(task.getPosition());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtils.copyFile((File)file, (OutputStream)baos);
                bos.write(baos.toByteArray());
                System.out.println(JPPFMessage.JEMJ025I.toMessage().getFormattedMessage(file.getAbsolutePath(), baos.size()));
                baos.close();
            }
            bos.close();
            System.out.println(JPPFMessage.JEMJ026I.toMessage().getFormattedMessage(new Object[0]));
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

