/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.pepstock.jem.jppf.ChunkDefinition;

public class ChunksFactory {
    public static final long DEFAULT_BUFFER_SIZE = 4096L;
    private static final long MINIMUM_BUFFER_SIZE = 1024L;

    public static final LinkedList<ChunkDefinition> getChunks(File file) throws IOException {
        return ChunksFactory.getChunks(file, 4096L);
    }

    public static final LinkedList<ChunkDefinition> getChunks(File file, long bufferSize) throws IOException {
        LinkedList<ChunkDefinition> list = new LinkedList<ChunkDefinition>();
        bufferSize = Math.max(bufferSize, 1024L);
        long maxLen = file.length() - 1L;
        long chunkStart = 0L;
        long chunkEnd = 0L;
        long skip = 0L;
        while (chunkStart < maxLen) {
            skip += bufferSize;
            chunkEnd = skip = Math.min(skip, maxLen);
            list.add(new ChunkDefinition(chunkStart, chunkEnd));
            chunkStart = chunkEnd + 1L;
        }
        return list;
    }

    public static final LinkedList<ChunkDefinition> getChunksByChunk(ChunkDefinition chunk) throws IOException {
        return ChunksFactory.getChunksByChunk(chunk, 4096L);
    }

    public static final LinkedList<ChunkDefinition> getChunksByChunk(ChunkDefinition chunk, long bufferSize) throws IOException {
        LinkedList<ChunkDefinition> list = new LinkedList<ChunkDefinition>();
        bufferSize = Math.max(bufferSize, 1024L);
        long chunkStart = chunk.getStart();
        long chunkEnd = 0L;
        long skip = chunk.getStart() - 1L;
        while (chunkStart < chunk.getEnd()) {
            skip += bufferSize;
            chunkEnd = skip = Math.min(skip, chunk.getEnd());
            list.add(new ChunkDefinition(chunkStart, chunkEnd));
            chunkStart = chunkEnd + 1L;
        }
        return list;
    }

    public static final LinkedList<ChunkDefinition> getChunksByDelimiter(File file) throws IOException {
        return ChunksFactory.getChunksByDelimiter(file, 4096L);
    }

    public static final LinkedList<ChunkDefinition> getChunksByDelimiter(File file, long bufferSize) throws IOException {
        return ChunksFactory.getChunksByDelimiter(file, bufferSize, System.getProperty("line.separator").charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LinkedList<ChunkDefinition> getChunksByDelimiter(File file, long bufferSize, char delimiter) throws IOException {
        LinkedList<ChunkDefinition> list = new LinkedList<ChunkDefinition>();
        bufferSize = Math.max(bufferSize, 1024L);
        long possibleChunksCount = file.length() / bufferSize;
        RandomAccessFile istream = null;
        try {
            istream = new RandomAccessFile(file, "r");
            long chunkStart = 0L;
            long chunkEnd = 0L;
            long skip = 0L;
            int i = 0;
            while ((long)i < possibleChunksCount - 1L) {
                skip = (long)(i + 1) * bufferSize;
                if (skip > chunkStart) {
                    int read;
                    istream.seek(skip);
                    while ((read = istream.read()) != delimiter && read != -1) {
                    }
                    chunkEnd = istream.getFilePointer() - 1L;
                    list.add(new ChunkDefinition(chunkStart, chunkEnd));
                    chunkStart = chunkEnd + 1L;
                }
                ++i;
            }
            if (chunkStart < file.length()) {
                list.add(new ChunkDefinition(chunkStart, file.length() - 1L));
            }
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LinkedList<ChunkDefinition> getChunksByDelimiter(File file, long bufferSize, String delimiter) throws IOException {
        LinkedList<ChunkDefinition> list = new LinkedList<ChunkDefinition>();
        long possibleChunksCount = file.length() / bufferSize;
        RandomAccessFile istream = null;
        try {
            istream = new RandomAccessFile(file, "r");
            long chunkStart = 0L;
            long chunkEnd = 0L;
            long skip = 0L;
            int i = 0;
            while ((long)i < possibleChunksCount - 1L) {
                skip = (long)(i + 1) * bufferSize;
                if (skip > chunkStart) {
                    int read;
                    istream.seek(skip);
                    int delimiterOffset = 0;
                    while ((read = istream.read()) != -1) {
                        if (read == delimiter.charAt(delimiterOffset)) {
                            if (++delimiterOffset != delimiter.length()) continue;
                            break;
                        }
                        delimiterOffset = 0;
                    }
                    chunkEnd = istream.getFilePointer() - 1L;
                    list.add(new ChunkDefinition(chunkStart, chunkEnd));
                    chunkStart = chunkEnd + 1L;
                }
                ++i;
            }
            if (chunkStart < file.length()) {
                list.add(new ChunkDefinition(chunkStart, file.length() - 1L));
            }
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }
}

