/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.pepstock.jem.io.IoMessage;

public class BytesArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 2048;
    byte[] buf;
    int count = 0;

    public BytesArray() {
        this(2048);
    }

    public BytesArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(IoMessage.JEMI001E.toMessage().getFormattedMessage(size));
        }
        this.buf = new byte[size];
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException(IoMessage.JEMI002E.toMessage().getFormattedMessage(off, len, b.length));
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream in) throws IOException {
        byte[] buffer = new byte[2048];
        try {
            int n;
            while ((n = in.read(buffer)) > 0) {
                this.write(buffer, 0, n);
            }
        }
        finally {
            in.close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public byte read(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException(IoMessage.JEMI002E.toMessage().getFormattedMessage(index, 1, this.count));
        }
        return this.buf[index];
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }
}

