/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.factories;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.BuildException;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.VariableSubstituter;

public abstract class AbstractFactory
implements JemFactory {
    private static final long serialVersionUID = 1L;
    private static final String VALUES_SEPARATOR = ";";
    private final Properties PROPERTIES = new Properties();
    private Properties properties = null;
    private boolean useSudo = false;

    public AbstractFactory() {
        this.PROPERTIES.putAll((Map<?, ?>)System.getProperties());
    }

    @Override
    public void init(Properties properties) throws Exception {
        this.properties = properties;
        this.useSudo = Parser.parseBoolean(properties.getProperty("jem.switch.user"), false);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public boolean isUseSudo() {
        return this.useSudo;
    }

    public void setUseSudo(boolean useSudo) {
        this.useSudo = useSudo;
    }

    public String resolvePathNames(String value, String pathKey) {
        value = VariableSubstituter.substitute(value, this.PROPERTIES);
        String pathSeparator = System.getProperty("path.separator");
        StringBuffer sb = new StringBuffer();
        String[] filesNames = value.split(VALUES_SEPARATOR);
        for (int i = 0; i < filesNames.length; ++i) {
            File filePath = this.getFile(FilenameUtils.normalize((String)filesNames[i], (boolean)true), pathKey);
            if (i > 0) {
                sb.append(pathSeparator);
            }
            sb.append(filePath.getAbsolutePath());
        }
        return sb.toString();
    }

    private File getFile(String fileName, String pathKey) throws BuildException {
        File checkFile = new File(fileName);
        String checkFileName = FilenameUtils.normalize((String)checkFile.getAbsolutePath(), (boolean)true);
        if (checkFileName.equalsIgnoreCase(fileName)) {
            return checkFile;
        }
        String path = System.getProperty(pathKey);
        if (fileName.startsWith(path)) {
            return new File(fileName);
        }
        return new File(path, fileName);
    }
}

