/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands.resources;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.console.JemConsole;
import org.pepstock.jem.console.commands.resources.ResourceCommand;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.Resources;
import org.pepstock.jem.node.resources.XmlUtil;

public class Set
extends ResourceCommand {
    private static final String ACTION = Set.class.getName();
    private static final String KEY = "setResources";
    private static final String DESCRIPTION = "Adds and updates a resource defintion by resource definition xml file";
    private static String SOURCE = "source";

    public Set() {
        super(ACTION);
    }

    @Override
    public void execute(String userid, String groupid) throws Exception {
        OptionBuilder.withArgName((String)SOURCE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given url resource definition");
        Option source = OptionBuilder.create((String)SOURCE);
        source.setRequired(true);
        ArgumentsParser parser = new ArgumentsParser(this.getClass().getName(), source);
        Properties props = parser.parseArg(this.getArguments());
        String source_file = props.getProperty(SOURCE);
        URL url = null;
        try {
            url = new URL(source_file);
        }
        catch (MalformedURLException ex) {
            File propsFile = new File(source_file);
            if (!propsFile.isAbsolute()) {
                propsFile = new File(JemConsole.CURRENT_DIRECTORY, source_file);
            }
            url = propsFile.toURI().toURL();
        }
        Object data = XmlUtil.getXStream().fromXML(url.openStream());
        if (!(data instanceof Resource) && !(data instanceof Resources)) {
            throw new Exception("Source file doesn't contain any resource or resources object but '" + data.getClass().getName() + "'");
        }
        Object object = HttpManager.getInstance().execute("/servlet/resources", this.getParameters(), data);
        Boolean isAdded = (Boolean)object;
        LogAppl.getInstance().emit((MessageInterface)(isAdded != false ? NodeMessage.JEMC052I : NodeMessage.JEMC053I), data.toString());
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

