/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands.resources;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.console.JemConsole;
import org.pepstock.jem.console.commands.resources.ResourceCommand;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.Resources;
import org.pepstock.jem.node.resources.XmlUtil;

public class GetList
extends ResourceCommand {
    private static final String ACTION = GetList.class.getName();
    private static final String KEY = "getResourcesList";
    private static final String DESCRIPTION = "Returns the defined resources list";
    private static String FILE = "file";
    private static String NAME = "name";

    public GetList() {
        super(ACTION);
    }

    @Override
    public void execute(String userid, String groupid) throws Exception {
        Object object;
        OptionBuilder.withArgName((String)FILE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resource definition file");
        Option properties = OptionBuilder.create((String)FILE);
        OptionBuilder.withArgName((String)NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resource name");
        Option name = OptionBuilder.create((String)NAME);
        ArgumentsParser parser = new ArgumentsParser(GetList.class.getName(), properties, name);
        Properties props = parser.parseArg(this.getArguments());
        String resource_file = props.getProperty(FILE);
        String resource_name = props.getProperty(NAME);
        File propsFile = null;
        if (resource_file != null && !(propsFile = new File(resource_file)).isAbsolute()) {
            propsFile = new File(JemConsole.CURRENT_DIRECTORY, resource_file);
        }
        if ((object = HttpManager.getInstance().execute("/servlet/resources", this.getParameters(), resource_name != null ? resource_name : "*")) instanceof Resources) {
            Resources resources = (Resources)object;
            StringBuffer buffer = new StringBuffer();
            for (Resource res : resources.getResources()) {
                buffer.append(res.toString()).append('\n');
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC064I, buffer.toString());
            if (propsFile != null) {
                XStream xs = XmlUtil.getXStream();
                xs.toXML((Object)resources, (OutputStream)new FileOutputStream(propsFile));
            }
        } else {
            throw new Exception("Source file doesn't contain any resource or resources object but '" + object.getClass().getName() + "'");
        }
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

