/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands.resources;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.console.JemConsole;
import org.pepstock.jem.console.commands.resources.ResourceCommand;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.XmlUtil;

public class Get
extends ResourceCommand {
    private static final String ACTION = Get.class.getName();
    private static final String KEY = "getResource";
    private static final String DESCRIPTION = "Returns the resource defintion by resource name";
    private static String FILE = "file";
    private static String NAME = "name";

    public Get() {
        super(ACTION);
    }

    @Override
    public void execute(String userid, String groupid) throws Exception {
        Object object;
        OptionBuilder.withArgName((String)FILE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resource definition file");
        Option properties = OptionBuilder.create((String)FILE);
        OptionBuilder.withArgName((String)NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given resource name");
        Option name = OptionBuilder.create((String)NAME);
        name.setRequired(true);
        ArgumentsParser parser = new ArgumentsParser(this.getClass().getName(), name, properties);
        Properties props = parser.parseArg(this.getArguments());
        String resource_file = props.getProperty(FILE);
        String resource_name = props.getProperty(NAME);
        File propsFile = null;
        if (resource_file != null && !(propsFile = new File(resource_file)).isAbsolute()) {
            propsFile = new File(JemConsole.CURRENT_DIRECTORY, resource_file);
        }
        if ((object = HttpManager.getInstance().execute("/servlet/resources", this.getParameters(), resource_name)) != null && object instanceof Resource) {
            Resource resource = (Resource)object;
            XStream xs = XmlUtil.getXStream();
            StringWriter writer = new StringWriter();
            xs.toXML((Object)resource, (Writer)writer);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC063I, resource.toString(), writer.getBuffer().toString());
            if (propsFile != null) {
                xs.toXML((Object)resource, (OutputStream)new FileOutputStream(propsFile));
            }
            return;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC062W, resource_name);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

