/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

public class ViewFile
extends Command {
    private static final String KEY = "view";
    private static final String DESCRIPTION = "Browses the content of a file";

    @Override
    public void execute(String userid, String groupid) throws Exception {
        String[] args = this.getArguments();
        if (args != null && args.length > 1) {
            File newPath = new File(args[1]);
            if (!newPath.exists()) {
                newPath = new File(FilenameUtils.concat((String)JemConsole.CURRENT_DIRECTORY.getAbsolutePath(), (String)args[1]));
            }
            if (newPath.exists() && !newPath.isDirectory()) {
                this.printFile(newPath);
            } else {
                this.print("File '" + args[1] + "' not found");
            }
        }
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printFile(File file) {
        Scanner sc = null;
        try {
            sc = new Scanner(file);
            sc.useDelimiter("\n");
            while (sc.hasNext()) {
                this.print(sc.next().toString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(JemConsole.CONSOLE.getWriter());
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
    }
}

