/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.Job;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.commands.util.Factory;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.console.JemConsole;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;

public class Submit
extends Command {
    private static final String KEY = "submit";
    private static final String DESCRIPTION = "Submits a job described by job control language file";
    private static final String SUBMIT_QUERY_STRING = "/servlet/submit";
    private static String JCL = "jcl";
    private static String TYPE = "type";

    @Override
    public void execute(String userid, String groupid) throws Exception {
        OptionBuilder.withArgName((String)JCL);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given jcl url/file");
        Option jcl = OptionBuilder.create((String)JCL);
        jcl.setRequired(true);
        OptionBuilder.withArgName((String)TYPE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given jcl type");
        Option type = OptionBuilder.create((String)TYPE);
        type.setRequired(true);
        ArgumentsParser parser = new ArgumentsParser(this.getClass().getName(), jcl, type);
        Properties props = parser.parseArg(this.getArguments());
        String jcl_url = props.getProperty(JCL);
        String jcl_type = props.getProperty(TYPE);
        this.submitJob(jcl_url, jcl_type, userid, groupid);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    private void submitJob(String jclUrl, String jclType, String userid, String groupid) throws Exception {
        URL url = null;
        try {
            url = new URL(jclUrl);
        }
        catch (MalformedURLException ex) {
            File jcl = new File(jclUrl);
            if (!jcl.isAbsolute()) {
                jcl = new File(JemConsole.CURRENT_DIRECTORY, jclUrl);
            }
            url = jcl.toURI().toURL();
        }
        PreJob preJob = Factory.createPreJob(url);
        preJob.setJclType(jclType);
        Job job = new Job();
        job.setUser(userid);
        job.setOrgUnit(groupid);
        job.setInputArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
        preJob.setJob(job);
        Object object = HttpManager.getInstance().execute(SUBMIT_QUERY_STRING, null, preJob);
        if (object != null && object instanceof String) {
            String jobId = (String)object;
            job.setId(jobId);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC020I, job.toString());
        }
    }
}

