/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

public class ListDirectory
extends Command {
    private static final String KEY = "ls";
    private static final String DESCRIPTION = "Listes the content of current local directory";
    private static final String FORMAT = "{0} {1} {2,date, dd-MMM-yyyy} {2,time, HH:mm:ss} {3,number,###,###,###,###,##0}";
    private static final String DIRECTORY = "<dir>";

    @Override
    public void execute(String userid, String groupid) throws Exception {
        this.print("Current directory: " + FilenameUtils.normalize((String)JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
        Object[] files = JemConsole.CURRENT_DIRECTORY.listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            String msg = MessageFormat.format(FORMAT, StringUtils.rightPad((String)FilenameUtils.getName((String)((File)files[i]).getAbsolutePath()), (int)32), ((File)files[i]).isDirectory() ? DIRECTORY : StringUtils.repeat((String)" ", (int)DIRECTORY.length()), new Date(((File)files[i]).lastModified()), ((File)files[i]).length());
            JemConsole.CONSOLE.print(msg);
        }
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

