/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console.commands;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

public class ChangeDirectory
extends Command {
    private static final String KEY = "cd";
    private static final String DESCRIPTION = "Changes the current local directory";
    private static final String CURRENT_DIRECTORY_COMMAND = ".";
    private static final String PARENT_DIRECTORY_COMMAND = "..";

    @Override
    public void execute(String userid, String groupid) throws Exception {
        String[] args = this.getArguments();
        if (args != null && args.length > 1 && !args[1].equalsIgnoreCase(CURRENT_DIRECTORY_COMMAND)) {
            File newPath = null;
            if (args[1].equalsIgnoreCase(PARENT_DIRECTORY_COMMAND)) {
                newPath = JemConsole.CURRENT_DIRECTORY.getParentFile();
            } else {
                newPath = new File(args[1]);
                if (!newPath.isAbsolute()) {
                    newPath = new File(FilenameUtils.concat((String)JemConsole.CURRENT_DIRECTORY.getAbsolutePath(), (String)args[1]));
                }
            }
            if (newPath.exists() && newPath.isDirectory()) {
                JemConsole.CURRENT_DIRECTORY = newPath;
                this.print("Current directory: " + FilenameUtils.normalize((String)JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
            } else {
                this.print("Directory '" + args[1] + "' not found");
            }
            return;
        }
        this.print("Current directory: " + FilenameUtils.normalize((String)JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

