/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console;

import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.commands.UserIDCommand;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.console.commands.ChangeDirectory;
import org.pepstock.jem.console.commands.ListDirectory;
import org.pepstock.jem.console.commands.Submit;
import org.pepstock.jem.console.commands.ViewFile;
import org.pepstock.jem.console.commands.resources.Get;
import org.pepstock.jem.console.commands.resources.GetList;
import org.pepstock.jem.console.commands.resources.Remove;
import org.pepstock.jem.console.commands.resources.Set;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.util.CmdConsole;

public class JemConsole
extends UserIDCommand {
    private static String HOST = "host";
    private static String USER = "user";
    private static final String HEADER_COMMAND = "Command";
    private static final String HEADER_DESCRIPTION = "Description";
    private static StringBuffer HELP_STRING = new StringBuffer();
    private Command[] commands = new Command[]{new GetList(), new Get(), new Set(), new Remove(), new Submit(), new ChangeDirectory(), new ListDirectory(), new ViewFile()};
    public static final CmdConsole CONSOLE = new CmdConsole();
    public static File CURRENT_DIRECTORY;

    public JemConsole() {
        this.loadtHelpFormat();
        File file = new File(".");
        CURRENT_DIRECTORY = new File(FilenameUtils.normalize((String)file.getAbsolutePath()));
    }

    public Command getCommand(String key) {
        for (int i = 0; i < this.commands.length; ++i) {
            if (!this.commands[i].getKey().equalsIgnoreCase(key)) continue;
            return this.commands[i];
        }
        return null;
    }

    private void loadtHelpFormat() {
        int hdrTabCounts;
        int maxLen = 0;
        for (int i = 0; i < this.commands.length; ++i) {
            maxLen = Math.max(maxLen, this.commands[i].getKey().length());
        }
        int tabCounts = (int)Math.floor((double)maxLen / 8.0) + 1;
        int underlineLen = HEADER_COMMAND.length() + HEADER_DESCRIPTION.length();
        HELP_STRING.append(HEADER_COMMAND);
        for (int k = hdrTabCounts = (int)Math.floor((double)HEADER_COMMAND.length() / 8.0); k < tabCounts; ++k) {
            HELP_STRING.append('\t');
            underlineLen += 8;
        }
        HELP_STRING.append(HEADER_DESCRIPTION);
        HELP_STRING.append('\n').append(StringUtils.repeat((String)"=", (int)underlineLen));
        for (int i = 0; i < this.commands.length; ++i) {
            int myTabCounts;
            HELP_STRING.append('\n').append(this.commands[i].getKey());
            for (int k = myTabCounts = (int)Math.floor((double)this.commands[i].getKey().length() / 8.0); k < tabCounts; ++k) {
                HELP_STRING.append('\t');
            }
            HELP_STRING.append(this.commands[i].getDescription());
        }
    }

    public static void main(String[] args) {
        LogAppl.getInstance(CONSOLE.getWriter());
        JemConsole jemconsole = new JemConsole();
        int rc = 0;
        try {
            OptionBuilder.withArgName((String)HOST);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"use given host and port to JEM http server");
            Option host = OptionBuilder.create((String)HOST);
            OptionBuilder.withArgName((String)USER);
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"use given userid to log in JEM");
            Option user = OptionBuilder.create((String)USER);
            ArgumentsParser parser = new ArgumentsParser(JemConsole.class.getName(), host, user);
            Properties properties = parser.parseArg(args);
            String http_host = null;
            if (properties.containsKey(HOST)) {
                http_host = properties.getProperty(HOST);
            } else {
                boolean waitForHost = true;
                while (waitForHost) {
                    String[] value = CONSOLE.readCommand("JEM HTTP host: ");
                    if (value == null || value.length <= 0) continue;
                    http_host = value[0];
                    waitForHost = false;
                }
            }
            HttpManager.createInstance(http_host);
            if (properties.containsKey(USER)) {
                jemconsole.setUserID(properties.getProperty(USER));
            }
            String password = CONSOLE.readPassword(jemconsole.getUserID());
            HttpManager.getInstance().login(jemconsole.getUserID(), password);
            String prompt = "JEM [" + HttpManager.getInstance().getGroupName() + "]--> ";
            CONSOLE.print("Current directory: " + FilenameUtils.normalize((String)CURRENT_DIRECTORY.getAbsolutePath()));
            boolean exit = false;
            while (!exit) {
                try {
                    String[] arguments = CONSOLE.readCommand(prompt);
                    if (arguments != null) {
                        if (arguments[0].equalsIgnoreCase("exit")) {
                            exit = true;
                        } else if (arguments[0].equalsIgnoreCase("help")) {
                            CONSOLE.print(HELP_STRING.toString());
                        } else {
                            Command command = jemconsole.getCommand(arguments[0]);
                            if (command != null) {
                                command.setArguments(arguments);
                                command.execute(jemconsole.getUserID(), jemconsole.getGroupID());
                            } else {
                                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC050I, "Command '" + arguments[0] + "' not found");
                                CONSOLE.print(HELP_STRING.toString());
                            }
                        }
                    }
                    CONSOLE.getWriter().flush();
                }
                catch (Exception e) {
                    e.printStackTrace(CONSOLE.getWriter());
                    CONSOLE.getWriter().flush();
                }
            }
        }
        catch (Exception e) {
            CONSOLE.print(e.getMessage());
            rc = 1;
        }
        try {
            HttpManager.getInstance().logout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(rc);
    }
}

