/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.console;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpManager {
    public static final String USER_PROPERTY_KEY = "jem.command.user";
    public static final String PASSWORD_PROPERTY_KEY = "jem.command.password";
    private static final String NAME_QUERY_STRING = "/servlet/getClusterGroupName";
    private static final String LOGIN_QUERY_STRING = "/servlet/login";
    private static final String LOGOUT_QUERY_STRING = "/servlet/logout";
    private static HttpManager MANAGER = null;
    private URI uri = null;
    private HttpClient client = new DefaultHttpClient();

    private HttpManager(String url) throws URISyntaxException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        URIBuilder builder = new URIBuilder(url);
        this.uri = builder.build();
        this.configureHttpClient();
    }

    public static HttpManager createInstance(String url) throws URISyntaxException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        if (MANAGER == null) {
            MANAGER = new HttpManager(url);
        }
        return HttpManager.getInstance();
    }

    public static HttpManager getInstance() {
        return MANAGER;
    }

    public String getGroupName() throws Exception {
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath(NAME_QUERY_STRING);
        HttpGet httpget = new HttpGet(builder.build());
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String responseBody = (String)this.client.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        return responseBody.trim();
    }

    public Object execute(String path, Properties parameters, Object parm) throws Exception {
        XStream streamer = new XStream();
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath(path);
        if (parameters != null && !parameters.isEmpty()) {
            for (Object key : parameters.keySet()) {
                String value = parameters.getProperty(key.toString());
                builder.setParameter(key.toString(), value);
            }
        }
        HttpPost httppost = new HttpPost(builder.build());
        if (parm != null) {
            StringEntity entity = new StringEntity(streamer.toXML(parm), ContentType.create((String)"text/xml", (String)"UTF-8"));
            httppost.setEntity((HttpEntity)entity);
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String responseBody = (String)this.client.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
        String result = responseBody.trim();
        try {
            return streamer.fromXML(result);
        }
        catch (Exception ex) {
            return result;
        }
    }

    public void login(String user, String password) throws ClientProtocolException, IOException, URISyntaxException {
        Properties properties = new Properties();
        properties.setProperty(USER_PROPERTY_KEY, user);
        properties.setProperty(PASSWORD_PROPERTY_KEY, password);
        StringWriter writer = new StringWriter();
        properties.store(writer, "Account info");
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath(LOGIN_QUERY_STRING);
        StringEntity entity = new StringEntity(writer.toString(), ContentType.create((String)"text/plain", (String)"UTF-8"));
        HttpPost httppost = new HttpPost(builder.build());
        httppost.setEntity((HttpEntity)entity);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        this.client.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
    }

    public void logout() throws ClientProtocolException, IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(this.uri);
        builder.setPath(LOGOUT_QUERY_STRING);
        HttpPost httppost = new HttpPost(builder.build());
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        this.client.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
        this.client.getConnectionManager().shutdown();
    }

    private void configureHttpClient() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        if (this.uri.getScheme().equalsIgnoreCase("https")) {
            SSLSocketFactory sf = this.buildSSLSocketFactory();
            Scheme https = new Scheme(this.uri.getScheme(), this.uri.getPort(), (SchemeSocketFactory)sf);
            SchemeRegistry sr = this.client.getConnectionManager().getSchemeRegistry();
            sr.register(https);
        }
    }

    private SSLSocketFactory buildSSLSocketFactory() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        return new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }
}

