/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import java.io.File;
import java.util.Properties;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;

public class NodeProperties {
    public static final String JEM_NODE_XMX = "jem.node.Xmx";
    public static final String DEFAULT_NODE_XMX = "512";
    public static final String JEM_LOGIN_PROTOCOL_ENABLE_PROP = "jem.login.protocol.enable";
    public static final String JEM_KEYSTORE_NAME_PROP = "jem.keystore.name";
    public static final String JEM_KEYSTORE_PWD_PROP = "jem.keystore.pwd";
    public static final String JEM_CRYPT_KEY_PWD_PROP = "jem.crypt.key.pwd";
    public static final String DEFAULT_NOT_SET_PROP = "|NOT_SET|";
    public static final String JEM_ENVIRONMENT_NAME_PROP = "jem.environment.name";
    public static final String JEM_ENVIRONMENT_PASSWORD_PROP = "jem.environment.password";
    public static final String JEM_NODE_NAME_PROP = "jem.node.name";
    public static final String JEM_DOMAIN_PROP = "jem.domain";
    public static final String JEM_AFFINITY_PROP = "jem.affinity";
    public static final String JEM_OUTPUT_PROP = "jem.output";
    public static final String JEM_DATA_PROP = "jem.data";
    public static final String JEM_SOURCE_PROP = "jem.source";
    public static final String JEM_BINARY_PROP = "jem.binary";
    public static final String JEM_CLASSPATH_PROP = "jem.classpath";
    public static final String JEM_LIBRARY_PROP = "jem.library";
    public static final String JEM_PERSISTENCE_PROP = "jem.persistence";
    public static final String JEM_MULTICAST_GROUP_PROP = "jem.multicast.group";
    public static final String JEM_MULTICAST_PORT_PROP = "jem.multicast.port";
    public static final String JEM_PORT_AUTOINCREMENT_PROP = "jem.port.autoincrement";
    public static final String JEM_INTERFACES_ENABLE = "jem.interfaces.enable";
    public static final String JEM_INTERFACE = "jem.interface";
    public static final String JEM_DB_DRIVER = "jem.db.driver";
    public static final String JEM_DB_URL = "jem.db.url";
    public static final String JEM_DB_USER = "jem.db.user";
    public static final String DEFAULT_JEM_DB_USER = "root";
    public static final String JEM_DB_PASSWORD = "jem.db.password";
    public static final String DEFAULT_MULTICAST_GROUP = "233.0.0.1";
    public static final String DEFAULT_MULTICAST_PORT = "54327";
    public static final String DEFAULT_AUTOINCREMENT_PORT = "5710";
    public static final String DEFAULT_INTERFACE = "10.10.1.*";
    Properties properties;

    public NodeProperties(Properties properties) {
        this.properties = properties;
    }

    public void checkMandatoryTag() throws Exception {
        this.getEnvironmentName();
        this.getBinaryPath();
        this.getClasspath();
        this.getCryptKeyPwd();
        this.getDataPath();
        this.getEnvironmentPassword();
        this.getJemDbDriver();
        this.getJemDbUrl();
        this.getKeystorePwd();
        this.getLibraryPath();
        this.getOutputPath();
        this.getPersistencePath();
        this.getSourcePath();
    }

    public String getEnvironmentName() throws Exception {
        String propValue = this.properties.getProperty(JEM_ENVIRONMENT_NAME_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_ENVIRONMENT_NAME_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_ENVIRONMENT_NAME_PROP));
    }

    public String getEnvironmentPassword() throws Exception {
        String propValue = this.properties.getProperty(JEM_ENVIRONMENT_PASSWORD_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_ENVIRONMENT_PASSWORD_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_ENVIRONMENT_PASSWORD_PROP));
    }

    public String getNodeName() {
        String propValue = this.properties.getProperty(JEM_NODE_NAME_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return null;
    }

    public String getDomain() {
        String propValue = this.properties.getProperty(JEM_DOMAIN_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return "***";
    }

    public String getAffinity() {
        String propValue = this.properties.getProperty(JEM_AFFINITY_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return "***";
    }

    public String getOutputPath() throws Exception {
        String propValue = this.properties.getProperty(JEM_OUTPUT_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_OUTPUT_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_OUTPUT_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_OUTPUT_PROP));
    }

    public String getDataPath() throws Exception {
        String propValue = this.properties.getProperty(JEM_DATA_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_DATA_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_DATA_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_DATA_PROP));
    }

    public String getSourcePath() throws Exception {
        String propValue = this.properties.getProperty(JEM_SOURCE_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_SOURCE_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_SOURCE_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_SOURCE_PROP));
    }

    public String getBinaryPath() throws Exception {
        String propValue = this.properties.getProperty(JEM_BINARY_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_BINARY_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_BINARY_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_BINARY_PROP));
    }

    public String getClasspath() throws Exception {
        String propValue = this.properties.getProperty(JEM_CLASSPATH_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_CLASSPATH_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_CLASSPATH_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_CLASSPATH_PROP));
    }

    public String getLibraryPath() throws Exception {
        String propValue = this.properties.getProperty(JEM_LIBRARY_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_LIBRARY_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_LIBRARY_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_LIBRARY_PROP));
    }

    public String getPersistencePath() throws Exception {
        String propValue = this.properties.getProperty(JEM_PERSISTENCE_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            this.checkPath(propValue, JEM_PERSISTENCE_PROP);
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_PERSISTENCE_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_PERSISTENCE_PROP));
    }

    public String getMulticastGroup() {
        String propValue = this.properties.getProperty(JEM_MULTICAST_GROUP_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return DEFAULT_MULTICAST_GROUP;
    }

    public String getMulticastPort() {
        String propValue = this.properties.getProperty(JEM_MULTICAST_PORT_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return DEFAULT_MULTICAST_PORT;
    }

    public String getAutoincrementPort() {
        String propValue = this.properties.getProperty(JEM_PORT_AUTOINCREMENT_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return DEFAULT_AUTOINCREMENT_PORT;
    }

    public boolean isLoginModuleEnable() {
        String propValue = this.properties.getProperty(JEM_LOGIN_PROTOCOL_ENABLE_PROP);
        return "true".equalsIgnoreCase(propValue);
    }

    public String getKeystoreName() throws Exception {
        String propValue = this.properties.getProperty(JEM_KEYSTORE_NAME_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            String keystoreName = propValue + "_" + this.getEnvironmentName() + ".keystore";
            return keystoreName;
        }
        String keystoreName = this.getEnvironmentName() + ".keystore";
        return keystoreName;
    }

    public String getUserKeystoreName() throws Exception {
        return "user_certificates_" + this.getEnvironmentName() + ".keystore";
    }

    public String getKeystorePwd() throws Exception {
        String propValue = this.properties.getProperty(JEM_KEYSTORE_PWD_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_KEYSTORE_PWD_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_KEYSTORE_PWD_PROP));
    }

    public String getCryptKeyPwd() throws Exception {
        String propValue = this.properties.getProperty(JEM_CRYPT_KEY_PWD_PROP);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_CRYPT_KEY_PWD_PROP);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_CRYPT_KEY_PWD_PROP));
    }

    public String getNodeXmx() {
        String propValue = this.properties.getProperty(JEM_NODE_XMX);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return DEFAULT_NODE_XMX;
    }

    public boolean isInterfacesEnable() {
        String propValue = this.properties.getProperty(JEM_INTERFACE);
        return propValue != null && !propValue.trim().equals("");
    }

    public String getInterface() {
        String propValue = this.properties.getProperty(JEM_INTERFACE);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue;
        }
        return DEFAULT_INTERFACE;
    }

    public String getJemDbDriver() throws Exception {
        String propValue = this.properties.getProperty(JEM_DB_DRIVER);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue.trim();
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_DB_DRIVER);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_DB_DRIVER));
    }

    public String getJemDbUrl() throws Exception {
        String propValue = this.properties.getProperty(JEM_DB_URL);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue.trim();
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC066E, JEM_DB_URL);
        throw new Exception(NodeMessage.JEMC066E.toMessage().getFormattedMessage(JEM_DB_URL));
    }

    public String getJemDbUser() {
        String propValue = this.properties.getProperty(JEM_DB_USER);
        if (propValue != null && !propValue.trim().equals("")) {
            return propValue.trim();
        }
        return DEFAULT_JEM_DB_USER;
    }

    public String getJemDbPassword() {
        String propValue = this.properties.getProperty(JEM_DB_PASSWORD);
        if (propValue != null) {
            return propValue.trim();
        }
        return "";
    }

    private void checkPath(String propValue, String propName) throws Exception {
        if (propValue.contains(" ")) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC087E, propValue, propName);
            throw new Exception(NodeMessage.JEMC087E.toMessage().getFormattedMessage(propValue, propName));
        }
        File path = new File(propValue);
        if (!path.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC088E, propValue, propName);
            throw new Exception(NodeMessage.JEMC088E.toMessage().getFormattedMessage(propValue, propName));
        }
    }
}

