/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.pepstock.jem.commands.util.NodeProperties;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;

public class NodeAttributes {
    private static final String NODE_NAME_PREFIX = "node-";
    private static final String TEMPLATE_SOURCE = "src";
    private static final String TEMPLATE_GFS = "gfs";
    public static final String TEMPLATE_ENV_DIRECTORY_NAME = "envname";
    public static final String TEMPLATE_NODE_DIRECTORY_NAME = "nodename";
    public static final String TEMPLATE_WAR_DIRECTORY_NAME = "war";
    public static final String TEMPLATE_WAR_FILE_NAME = "jem_gwt.war";
    private File templateEnvDirectory;
    private File templateGfsConfigDirectory;
    private File templateNodeDirectory;
    private String nodeName;
    private String envName;
    private String jemHome;
    private File gfsConfigDirectory;
    private File envDir;
    private File warDir;
    private File warFile;
    private File nodeDir;
    private File output;
    private File data;
    private File source;
    private File binary;
    private File classpath;
    private File library;
    private File persistence;
    private NodeProperties nodeProperties;

    public NodeAttributes(String jemHome, NodeProperties nodeProperties) throws Exception {
        this.nodeProperties = nodeProperties;
        this.jemHome = jemHome;
    }

    public void init() throws Exception {
        String fs = "/";
        this.envName = this.nodeProperties.getEnvironmentName();
        this.envDir = new File(this.jemHome + fs + this.envName);
        this.warDir = new File(this.jemHome + fs + this.envName + fs + TEMPLATE_WAR_DIRECTORY_NAME);
        this.warFile = new File(this.jemHome + fs + this.envName + fs + TEMPLATE_WAR_FILE_NAME);
        this.setNodeName(this.nodeProperties.getNodeName());
        this.nodeDir = new File(this.envDir + fs + this.nodeName);
        this.templateEnvDirectory = new File(this.jemHome + fs + TEMPLATE_SOURCE + fs + TEMPLATE_ENV_DIRECTORY_NAME);
        this.templateNodeDirectory = new File(this.jemHome + fs + TEMPLATE_SOURCE + fs + TEMPLATE_ENV_DIRECTORY_NAME + fs + TEMPLATE_NODE_DIRECTORY_NAME);
        this.templateGfsConfigDirectory = new File(this.jemHome + fs + TEMPLATE_SOURCE + fs + TEMPLATE_GFS + fs + TEMPLATE_ENV_DIRECTORY_NAME);
        this.output = new File(this.nodeProperties.getOutputPath());
        if (!this.output.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getOutputPath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getOutputPath()));
        }
        this.data = new File(this.nodeProperties.getDataPath());
        if (!this.data.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getDataPath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getDataPath()));
        }
        this.source = new File(this.nodeProperties.getSourcePath());
        if (!this.source.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getSourcePath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getSourcePath()));
        }
        this.binary = new File(this.nodeProperties.getBinaryPath());
        if (!this.binary.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getBinaryPath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getBinaryPath()));
        }
        this.classpath = new File(this.nodeProperties.getClasspath());
        if (!this.classpath.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getClasspath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getClasspath()));
        }
        this.library = new File(this.nodeProperties.getLibraryPath());
        if (!this.library.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getLibraryPath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getLibraryPath()));
        }
        this.persistence = new File(this.nodeProperties.getPersistencePath());
        if (!this.persistence.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC067E, this.nodeProperties.getPersistencePath());
            throw new Exception(NodeMessage.JEMC067E.toMessage().getFormattedMessage(this.nodeProperties.getPersistencePath()));
        }
        this.gfsConfigDirectory = new File(this.nodeProperties.getPersistencePath() + fs + this.nodeProperties.getEnvironmentName());
    }

    public File getOutput() {
        return this.output;
    }

    public File getData() {
        return this.data;
    }

    public File getSource() {
        return this.source;
    }

    public File getBinary() {
        return this.binary;
    }

    public File getClasspath() {
        return this.classpath;
    }

    public File getLibrary() {
        return this.library;
    }

    public File getPersistence() {
        return this.persistence;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public File getTemplateGfsConfigDirectory() {
        return this.templateGfsConfigDirectory;
    }

    public File getGfsConfigDirectory() {
        return this.gfsConfigDirectory;
    }

    public File getTemplateEnvDirectory() {
        return this.templateEnvDirectory;
    }

    public File getTemplateNodeDirectory() {
        return this.templateNodeDirectory;
    }

    public File getEnvDir() {
        return this.envDir;
    }

    public File getWarDir() {
        return this.warDir;
    }

    public File getWarFile() {
        return this.warFile;
    }

    public File getNodeDir() {
        return this.nodeDir;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    private void setNodeName(String nodeName) {
        if (nodeName == null) {
            if (!this.getEnvDir().exists()) {
                this.nodeName = "node-000";
            } else {
                String[] automaticNodeNames = this.getEnvDir().list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().startsWith(NodeAttributes.NODE_NAME_PREFIX) && dir.isDirectory();
                    }
                });
                if (automaticNodeNames == null || automaticNodeNames.length == 0) {
                    this.nodeName = "node-000";
                } else {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    Integer currIndex = 0;
                    for (String currName : automaticNodeNames) {
                        try {
                            currIndex = new Integer(currName.substring(5));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        list.add(currIndex);
                    }
                    Integer maxIndex = (Integer)Collections.max(list);
                    Integer newIndex = maxIndex + 1;
                    String newIndexStr = String.format("%03d", newIndex);
                    this.nodeName = NODE_NAME_PREFIX + newIndexStr;
                }
            }
        } else {
            this.nodeName = nodeName;
        }
    }

    public String getEnvName() {
        return this.envName;
    }

    public String getJemHome() {
        return this.jemHome;
    }
}

