/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.pepstock.jem.PreJob;

public class HttpUtil {
    public static final String USER_PROPERTY_KEY = "jem.command.user";
    public static final String PASSWORD_PROPERTY_KEY = "jem.command.password";
    private static final String NAME_QUERY_STRING = "/servlet/getClusterGroupName";
    private static final String MEMBERS_QUERY_STRING = "/servlet/getClusterMembers";
    private static final String LOGIN_QUERY_STRING = "/servlet/login";
    private static final String LOGOUT_QUERY_STRING = "/servlet/logout";
    private static final String SUBMIT_QUERY_STRING = "/servlet/submit";
    private static final String JOBID_QUERY_STRING = "/servlet/getJobById";
    private static final String ENDE_JOBID_QUERY_STRING = "/servlet/getEndedJobById";
    private static final String COMMON_RESOURCES_QUERY_STRING = "/servlet/resources";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getMembers(String url) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        String[] nodes = null;
        try {
            String completeUrl = url + MEMBERS_QUERY_STRING;
            HttpGet httpget = new HttpGet(completeUrl);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            nodes = responseBody.trim().split(",");
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGroupName(String url) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        String groupName = null;
        try {
            String completeUrl = url + NAME_QUERY_STRING;
            HttpGet httpget = new HttpGet(completeUrl);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            groupName = responseBody.trim();
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String submit(String user, String password, String url, PreJob prejob) throws Exception {
        String jobId = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        XStream streamer = new XStream();
        String content = streamer.toXML((Object)prejob);
        boolean loggedIn = false;
        try {
            HttpUtil.login(user, password, url, (HttpClient)httpclient);
            loggedIn = true;
            String completeUrl = url + SUBMIT_QUERY_STRING;
            StringEntity entity = new StringEntity(content, ContentType.create((String)"text/xml", (String)"UTF-8"));
            HttpPost httppost = new HttpPost(completeUrl);
            httppost.setEntity((HttpEntity)entity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
            jobId = responseBody.trim();
        }
        finally {
            if (loggedIn) {
                try {
                    HttpUtil.logout(url, (HttpClient)httpclient);
                }
                catch (Exception e) {}
            }
            httpclient.getConnectionManager().shutdown();
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getJobByID(String user, String password, String url, String jobId, String queueName) throws Exception {
        Object returnedObject = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        XStream streamer = new XStream();
        boolean loggedIn = false;
        try {
            HttpUtil.login(user, password, url, (HttpClient)httpclient);
            loggedIn = true;
            String completeUrl = url + JOBID_QUERY_STRING + "?jobId=" + jobId + "&queueName=" + queueName;
            HttpGet httpget = new HttpGet(completeUrl);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            returnedObject = streamer.fromXML(responseBody.trim());
        }
        finally {
            if (loggedIn) {
                try {
                    HttpUtil.logout(url, (HttpClient)httpclient);
                }
                catch (Exception e) {}
            }
            httpclient.getConnectionManager().shutdown();
        }
        return returnedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getEndedJobByID(String user, String password, String url, String jobId) throws Exception {
        Object returnedObject = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        XStream streamer = new XStream();
        boolean loggedIn = false;
        try {
            HttpUtil.login(user, password, url, (HttpClient)httpclient);
            loggedIn = true;
            String completeUrl = url + ENDE_JOBID_QUERY_STRING + "?jobId=" + jobId;
            HttpGet httpget = new HttpGet(completeUrl);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            returnedObject = streamer.fromXML(responseBody.trim());
        }
        finally {
            if (loggedIn) {
                try {
                    HttpUtil.logout(url, (HttpClient)httpclient);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            httpclient.getConnectionManager().shutdown();
        }
        return returnedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object resource(String user, String password, String url, Class action, Object parm) throws Exception {
        Object returnedObject = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.configureHttpClient((HttpClient)httpclient, url);
        XStream streamer = new XStream();
        String content = null;
        if (parm != null) {
            content = streamer.toXML(parm);
        }
        boolean loggedIn = false;
        try {
            HttpUtil.login(user, password, url, (HttpClient)httpclient);
            loggedIn = true;
            String completeUrl = url + COMMON_RESOURCES_QUERY_STRING;
            URIBuilder builder = new URIBuilder(completeUrl);
            builder.setParameter("action", action.getName());
            URI uri = builder.build();
            HttpPost httppost = new HttpPost(uri);
            if (content != null) {
                StringEntity entity = new StringEntity(content, ContentType.create((String)"text/xml", (String)"UTF-8"));
                httppost.setEntity((HttpEntity)entity);
            }
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
            returnedObject = streamer.fromXML(responseBody.trim());
        }
        finally {
            if (loggedIn) {
                try {
                    HttpUtil.logout(url, (HttpClient)httpclient);
                }
                catch (Exception e) {}
            }
            httpclient.getConnectionManager().shutdown();
        }
        return returnedObject;
    }

    private static void login(String user, String password, String url, HttpClient httpclient) throws ClientProtocolException, IOException {
        Properties properties = new Properties();
        properties.setProperty(USER_PROPERTY_KEY, user);
        properties.setProperty(PASSWORD_PROPERTY_KEY, password);
        StringWriter writer = new StringWriter();
        properties.store(writer, "Account info");
        String completeUrl = url + LOGIN_QUERY_STRING;
        StringEntity entity = new StringEntity(writer.toString(), ContentType.create((String)"text/plain", (String)"UTF-8"));
        HttpPost httppost = new HttpPost(completeUrl);
        httppost.setEntity((HttpEntity)entity);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        httpclient.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
    }

    private static void logout(String url, HttpClient httpclient) throws ClientProtocolException, IOException {
        String completeUrl = url + LOGOUT_QUERY_STRING;
        HttpPost httppost = new HttpPost(completeUrl);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        httpclient.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
    }

    private static void configureHttpClient(HttpClient client, String uri) throws URISyntaxException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        URI uriObject = URI.create(uri);
        HttpUtil.configureHttpClient(client, uriObject);
    }

    private static void configureHttpClient(HttpClient client, URI uri) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        if (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("https")) {
            SSLSocketFactory sf = HttpUtil.buildSSLSocketFactory();
            int port = uri.getPort();
            if (port == -1) {
                port = 443;
            }
            Scheme https = new Scheme(uri.getScheme(), port, (SchemeSocketFactory)sf);
            SchemeRegistry sr = client.getConnectionManager().getSchemeRegistry();
            sr.register(https);
        }
    }

    private static SSLSocketFactory buildSSLSocketFactory() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        return new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }
}

