/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.SocketInterceptor;
import java.net.InetAddress;
import org.pepstock.jem.commands.util.HttpUtil;
import org.pepstock.jem.node.security.socketinterceptor.SubmitInterceptor;

public class HazelcastUtil {
    public static final HazelcastInstance getLocalInstance(String env, String port, String envPassword, String privateKeyPathFile, String privateKeyPasswd, String userId) throws Exception {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName(env).setPassword(envPassword);
        clientConfig.addAddress(new String[]{InetAddress.getLocalHost().getHostAddress() + ":" + port});
        if (privateKeyPathFile != null) {
            SubmitInterceptor myClientSocketInterceptor = new SubmitInterceptor(privateKeyPathFile, privateKeyPasswd, userId);
            clientConfig.setSocketInterceptor((SocketInterceptor)myClientSocketInterceptor);
        }
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    public static final HazelcastInstance getInstance(String url, String envPassword, String privateKeyPathFile, String privateKeyPassword, String userId) throws Exception {
        String groupName = HttpUtil.getGroupName(url);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName(groupName).setPassword(envPassword);
        clientConfig.addAddress(HttpUtil.getMembers(url));
        if (privateKeyPathFile != null) {
            SubmitInterceptor myClientSocketInterceptor = new SubmitInterceptor(privateKeyPathFile, privateKeyPassword, userId);
            clientConfig.setSocketInterceptor((SocketInterceptor)myClientSocketInterceptor);
        }
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }
}

