/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.commands.util.NodeAttributes;

public class ConfsUpdater {
    private NodeAttributes nodeAttributes;

    public ConfsUpdater(NodeAttributes nodeAttributes) {
        this.nodeAttributes = nodeAttributes;
    }

    public void updateEnvConfigs() throws Exception {
        String fs = System.getProperty("file.separator");
        String hazelcastXmlName = "jem-env-hazelcast.xml";
        String hazelcastXml = this.nodeAttributes.getGfsConfigDirectory().getAbsolutePath() + fs + "config" + fs + hazelcastXmlName;
        this.updateFile(new File(hazelcastXml));
        File src = new File(hazelcastXml);
        File dest = new File(this.nodeAttributes.getWarDir().getPath() + fs + "WEB-INF" + fs + "config" + fs + hazelcastXmlName);
        FileUtils.copyFile((File)src, (File)dest);
        String jemEnvXmlName = "jem-env.xml";
        String jemEnvXml = this.nodeAttributes.getGfsConfigDirectory().getAbsolutePath() + fs + "config" + fs + jemEnvXmlName;
        this.updateFile(new File(jemEnvXml));
        String envCommonName = "env_common.conf";
        String envCommon = this.nodeAttributes.getEnvDir().getAbsolutePath() + fs + "config" + fs + envCommonName;
        this.updateFile(new File(envCommon));
    }

    public void updateNodeConfigs() throws Exception {
        String fs = System.getProperty("file.separator");
        String jemsh = this.nodeAttributes.getNodeDir() + fs + "bin" + fs + "jem.sh";
        this.updateFile(new File(jemsh));
        String jemNodeXml = this.nodeAttributes.getNodeDir() + fs + "config" + fs + "jem-node.xml";
        this.updateFile(new File(jemNodeXml));
        String wrapperConf = this.nodeAttributes.getNodeDir() + fs + "config" + fs + "node_wrapper.conf";
        this.updateFile(new File(wrapperConf));
    }

    private void updateFile(File fileToUpdate) throws Exception {
        String content = FileUtils.readFileToString((File)fileToUpdate);
        content = content.replace(this.getVariableSubstituteFormat("jem.affinity"), this.nodeAttributes.getNodeProperties().getAffinity());
        content = content.replace(this.getVariableSubstituteFormat("jem.binary"), this.nodeAttributes.getNodeProperties().getBinaryPath());
        content = content.replace(this.getVariableSubstituteFormat("jem.classpath"), this.nodeAttributes.getNodeProperties().getClasspath());
        content = content.replace(this.getVariableSubstituteFormat("jem.data"), this.nodeAttributes.getNodeProperties().getDataPath());
        content = content.replace(this.getVariableSubstituteFormat("jem.domain"), this.nodeAttributes.getNodeProperties().getDomain());
        content = content.replace(this.getVariableSubstituteFormat("jem.environment.name"), this.nodeAttributes.getNodeProperties().getEnvironmentName());
        content = content.replace(this.getVariableSubstituteFormat("jem.environment.password"), this.nodeAttributes.getNodeProperties().getEnvironmentPassword());
        content = content.replace(this.getVariableSubstituteFormat("jem.library"), this.nodeAttributes.getNodeProperties().getLibraryPath());
        content = content.replace(this.getVariableSubstituteFormat("jem.multicast.group"), this.nodeAttributes.getNodeProperties().getMulticastGroup());
        content = content.replace(this.getVariableSubstituteFormat("jem.multicast.port"), this.nodeAttributes.getNodeProperties().getMulticastPort());
        content = content.replace(this.getVariableSubstituteFormat("jem.node.name"), this.nodeAttributes.getNodeName());
        content = content.replace(this.getVariableSubstituteFormat("jem.output"), this.nodeAttributes.getNodeProperties().getOutputPath());
        content = content.replace(this.getVariableSubstituteFormat("jem.persistence"), this.nodeAttributes.getNodeProperties().getPersistencePath());
        content = content.replace(this.getVariableSubstituteFormat("jem.port.autoincrement"), this.nodeAttributes.getNodeProperties().getAutoincrementPort());
        content = content.replace(this.getVariableSubstituteFormat("jem.source"), this.nodeAttributes.getNodeProperties().getSourcePath());
        content = content.replace(this.getVariableSubstituteFormat("jem.login.protocol.enable"), Boolean.toString(this.nodeAttributes.getNodeProperties().isLoginModuleEnable()));
        content = content.replace(this.getVariableSubstituteFormat("jem.keystore.name"), this.nodeAttributes.getNodeProperties().getKeystoreName());
        content = content.replace(this.getVariableSubstituteFormat("jem.keystore.pwd"), this.nodeAttributes.getNodeProperties().getKeystorePwd());
        content = content.replace(this.getVariableSubstituteFormat("jem.crypt.key.pwd"), this.nodeAttributes.getNodeProperties().getCryptKeyPwd());
        content = content.replace(this.getVariableSubstituteFormat("jem.node.Xmx"), this.nodeAttributes.getNodeProperties().getNodeXmx());
        content = content.replace(this.getVariableSubstituteFormat("jem.interfaces.enable"), Boolean.toString(this.nodeAttributes.getNodeProperties().isInterfacesEnable()));
        content = content.replace(this.getVariableSubstituteFormat("jem.interface"), this.nodeAttributes.getNodeProperties().getInterface());
        content = content.replace(this.getVariableSubstituteFormat("jem.db.driver"), this.nodeAttributes.getNodeProperties().getJemDbDriver());
        content = content.replace(this.getVariableSubstituteFormat("jem.db.url"), this.nodeAttributes.getNodeProperties().getJemDbUrl());
        content = content.replace(this.getVariableSubstituteFormat("jem.db.user"), this.nodeAttributes.getNodeProperties().getJemDbUser());
        content = content.replace(this.getVariableSubstituteFormat("jem.db.password"), this.nodeAttributes.getNodeProperties().getJemDbPassword());
        FileUtils.writeStringToFile((File)fileToUpdate, (String)content);
    }

    private String getVariableSubstituteFormat(String variableName) {
        return "#[" + variableName + "]";
    }
}

