/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;

public class ArgumentsParser {
    private String commandLine = null;
    private Option[] options = null;

    public ArgumentsParser(String commandLine, Option ... options) {
        this.commandLine = commandLine;
        this.options = options;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public Properties parseArg(String[] args) throws ParseException {
        Option help = new Option("help", "print this message");
        Options allOptions = new Options();
        allOptions.addOption(help);
        for (int i = 0; i < this.options.length; ++i) {
            allOptions.addOption(this.options[i]);
        }
        PosixParser parser = new PosixParser();
        try {
            Properties properties = new Properties();
            CommandLine line = parser.parse(allOptions, args);
            if (line.getOptions().length == 1 && line.hasOption("help")) {
                StringWriter writer = new StringWriter();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(new PrintWriter(writer), 74, this.getCommandLine(), "", allOptions, 1, 3, "");
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC056I, writer.getBuffer());
            } else {
                Option[] optionsLine = line.getOptions();
                for (int i = 0; i < optionsLine.length; ++i) {
                    String key = optionsLine[i].getArgName();
                    String value = optionsLine[i].hasArg() ? optionsLine[i].getValue() : "";
                    properties.setProperty(key, value);
                }
            }
            return properties;
        }
        catch (ParseException e) {
            StringWriter writer = new StringWriter();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(new PrintWriter(writer), 74, this.getCommandLine(), "", allOptions, 1, 3, "");
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC056I, writer.getBuffer());
            throw e;
        }
    }
}

