/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.Result;
import org.pepstock.jem.commands.OptionBuilderLock;
import org.pepstock.jem.commands.SubmitResult;
import org.pepstock.jem.commands.UserIDCommand;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.commands.util.Factory;
import org.pepstock.jem.commands.util.HazelcastUtil;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.jobs.GetMessagesLog;

public class Submit
extends UserIDCommand
implements MessageListener<Job> {
    public static final String JCL = "jcl";
    public static final String PASSWORD = "password";
    public static final String TYPE = "type";
    public static final String HOST = "host";
    public static final String NOWAIT = "nowait";
    public static final String PRINT_OUTPUT = "printOutput";
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PRIVATE_KEY_PWD = "privateKeyPwd";
    private String jclUrl = null;
    private String password = null;
    private String jclType = "ant";
    private String hostForJemWeb = null;
    private boolean noWait = false;
    private boolean printOutput = false;
    private HazelcastInstance client = null;
    private Object lock = new Object();
    private Job job = null;
    private String privateKey = null;
    private String privateKeyPassword = null;

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message<Job> endedJob) {
        if (((Job)endedJob.getMessageObject()).getRoutingInfo().getId() != null) {
            if (!this.job.getId().equals(((Job)endedJob.getMessageObject()).getRoutingInfo().getId())) {
                return;
            }
            this.job = (Job)endedJob.getMessageObject();
            if (!this.job.isNowait()) {
                IMap routedQueue = this.client.getMap("org.pepstock.jem.routed");
                routedQueue.remove((Object)this.job.getRoutingInfo().getId());
            }
        } else {
            if (!this.job.equals(endedJob.getMessageObject())) {
                return;
            }
            this.job = (Job)endedJob.getMessageObject();
        }
        Object object = this.getLock();
        synchronized (object) {
            this.getLock().notify();
        }
    }

    public void submitJob() throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        this.client = HazelcastUtil.getInstance(this.hostForJemWeb, this.password, this.privateKey, this.privateKeyPassword, this.getUserID());
        URL url = null;
        try {
            url = new URL(this.jclUrl);
        }
        catch (MalformedURLException ex) {
            File jcl = new File(this.jclUrl);
            url = jcl.toURI().toURL();
        }
        PreJob preJob = Factory.createPreJob(url);
        preJob.setJclType(this.jclType);
        this.job = new Job();
        this.job.setUser(this.getUserID());
        this.job.setOrgUnit(this.getGroupID());
        IdGenerator generator = this.client.getIdGenerator("org.pepstock.jem.job.id");
        long id = generator.newId();
        String jobId = Factory.createJobId(this.job, id);
        this.job.setId(jobId);
        this.job.setInputArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
        this.job.setNowait(this.noWait);
        preJob.setJob(this.job);
        ITopic topic = this.client.getTopic("org.pepstock.jem.job.ended");
        topic.addMessageListener((MessageListener)this);
        IQueue jclCheckingQueue = this.client.getQueue("org.pepstock.jem.jcl.checking");
        jclCheckingQueue.put((Object)preJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubmitResult executeCommand(String[] args) {
        Submit cc;
        int rc;
        block21: {
            LogAppl.getInstance();
            rc = 0;
            cc = new Submit();
            try {
                ArgumentsParser parser = null;
                Object object = OptionBuilderLock.getLock();
                synchronized (object) {
                    OptionBuilder.withArgName((String)JCL);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"use given jcl file");
                    Option jcl = OptionBuilder.create((String)JCL);
                    jcl.setRequired(true);
                    OptionBuilder.withArgName((String)PASSWORD);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"the hazelcast password for the environment");
                    Option passwd = OptionBuilder.create((String)PASSWORD);
                    passwd.setRequired(true);
                    OptionBuilder.withArgName((String)TYPE);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"use given jcl type");
                    Option type = OptionBuilder.create((String)TYPE);
                    type.setRequired(true);
                    OptionBuilder.withArgName((String)HOST);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"use given host to extract members cluster and group name");
                    Option host = OptionBuilder.create((String)HOST);
                    host.setRequired(true);
                    OptionBuilder.withArgName((String)NOWAIT);
                    OptionBuilder.withDescription((String)"use given do not wait for end of job");
                    Option wait = OptionBuilder.create((String)NOWAIT);
                    OptionBuilder.withArgName((String)PRINT_OUTPUT);
                    OptionBuilder.withDescription((String)"use given to print std output and error of job");
                    Option print_Output = OptionBuilder.create((String)PRINT_OUTPUT);
                    OptionBuilder.withArgName((String)PRIVATE_KEY);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"the private key path to supply in case of socket interceptor enabled");
                    Option pk = OptionBuilder.create((String)PRIVATE_KEY);
                    OptionBuilder.withArgName((String)PRIVATE_KEY_PWD);
                    OptionBuilder.hasArg();
                    OptionBuilder.withDescription((String)"the private key password");
                    Option pkPwd = OptionBuilder.create((String)PRIVATE_KEY_PWD);
                    parser = new ArgumentsParser(Submit.class.getName(), jcl, type, host, wait, print_Output, pk, passwd, pkPwd);
                }
                Properties properties = parser.parseArg(args);
                cc.jclUrl = properties.getProperty(JCL);
                cc.hostForJemWeb = properties.getProperty(HOST);
                cc.jclType = properties.getProperty(TYPE);
                cc.privateKey = properties.getProperty(PRIVATE_KEY);
                cc.privateKeyPassword = properties.getProperty(PRIVATE_KEY_PWD);
                cc.password = properties.getProperty(PASSWORD);
                if ("".equals(properties.getProperty(NOWAIT))) {
                    cc.noWait = true;
                }
                if ("".equals(properties.getProperty(PRINT_OUTPUT))) {
                    cc.printOutput = true;
                }
                if (cc.noWait && cc.printOutput) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC198W, NOWAIT, PRINT_OUTPUT);
                }
                cc.submitJob();
                if (cc.noWait) break block21;
                Object object2 = cc.getLock();
                synchronized (object2) {
                    boolean wait = true;
                    while (wait) {
                        try {
                            Result res;
                            cc.getLock().wait();
                            wait = false;
                            if (cc.job != null) {
                                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, cc.job.toString(), String.valueOf(cc.job.getResult().getReturnCode()));
                                if (cc.job.getResult().getReturnCode() != 0) {
                                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, cc.job.toString(), cc.job.getResult().getExceptionMessage());
                                }
                            }
                            rc = cc.job != null ? ((res = cc.job.getResult()) != null ? cc.job.getResult().getReturnCode() : 1) : 1;
                            if (cc.job == null || !cc.printOutput) continue;
                            Submit.printOutput(cc);
                        }
                        catch (InterruptedException e1) {
                            LogAppl.getInstance().emit(NodeMessage.JEMC017E);
                            rc = 1;
                        }
                    }
                }
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC033E, e);
                rc = 1;
            }
            finally {
                if (cc.client != null) {
                    cc.client.getLifecycleService().shutdown();
                }
            }
        }
        SubmitResult sr = new SubmitResult();
        if (cc.job != null) {
            sr.setJobId(cc.job.getId());
        }
        sr.setRc(rc);
        return sr;
    }

    private static void printOutput(Submit cc) throws Exception {
        Cluster cluster = cc.client.getCluster();
        Set set = cluster.getMembers();
        for (Member member : set) {
            if (member.isLiteMember()) continue;
            DistributedTask task = new DistributedTask((Callable)new GetMessagesLog(cc.job), member);
            ExecutorService executorService = cc.client.getExecutorService();
            executorService.execute((Runnable)task);
            try {
                OutputFileContent content = (OutputFileContent)task.get();
                System.out.println(content.getContent());
            }
            catch (InterruptedException e) {
                throw new Exception(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new Exception(e.getMessage(), e);
            }
            return;
        }
    }

    public static void main(String[] args) {
        SubmitResult sr = Submit.executeCommand(args);
        System.exit(sr.getRc());
    }
}

