/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.Job;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.Result;
import org.pepstock.jem.commands.OptionBuilderLock;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.commands.util.Factory;
import org.pepstock.jem.commands.util.HttpUtil;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.util.CmdConsole;

public class HttpSubmit {
    public static final String JCL = "jcl";
    public static final String TYPE = "type";
    public static final String HOST = "host";
    public static final String PASSWORD = "password";
    public static final String USER = "user";
    public static final String WAIT = "wait";
    private String jclUrl = null;
    private String jclType = "ant";
    private String hostForJemWeb = null;
    private String passwordValue = null;
    private String userValue = null;
    private boolean wait = false;

    public int submitJob() throws Exception {
        int rc = 0;
        URL url = null;
        try {
            url = new URL(this.jclUrl);
        }
        catch (MalformedURLException ex) {
            File jcl = new File(this.jclUrl);
            url = jcl.toURI().toURL();
        }
        PreJob preJob = Factory.createPreJob(url);
        preJob.setJclType(this.jclType);
        Job job = new Job();
        job.setUser(this.userValue);
        job.setInputArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
        preJob.setJob(job);
        String jobId = HttpUtil.submit(this.userValue, this.passwordValue, this.hostForJemWeb, preJob);
        job.setId(jobId);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC020I, job.toString());
        if (this.wait) {
            Job resultJob = null;
            while (resultJob == null) {
                Result res;
                Thread.sleep(30000L);
                Object obj = HttpUtil.getEndedJobByID(this.userValue, this.passwordValue, this.hostForJemWeb, jobId);
                if (!(obj instanceof Job)) continue;
                resultJob = (Job)obj;
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, resultJob.toString(), String.valueOf(resultJob.getResult().getReturnCode()));
                if (resultJob.getResult().getReturnCode() != 0) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, resultJob.toString(), resultJob.getResult().getExceptionMessage());
                }
                if ((res = resultJob.getResult()) != null) {
                    rc = resultJob.getResult().getReturnCode();
                    continue;
                }
                rc = 1;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommand(String[] args) {
        LogAppl.getInstance();
        int rc = 0;
        HttpSubmit cc = new HttpSubmit();
        try {
            ArgumentsParser parser = null;
            Object object = OptionBuilderLock.getLock();
            synchronized (object) {
                OptionBuilder.withArgName((String)JCL);
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"use given jcl file");
                Option jcl = OptionBuilder.create((String)JCL);
                jcl.setRequired(true);
                OptionBuilder.withArgName((String)TYPE);
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"use given jcl type");
                Option type = OptionBuilder.create((String)TYPE);
                type.setRequired(true);
                OptionBuilder.withArgName((String)HOST);
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"use given host to submit the job");
                Option host = OptionBuilder.create((String)HOST);
                host.setRequired(true);
                OptionBuilder.withArgName((String)WAIT);
                OptionBuilder.withDescription((String)"use given to wait for end of job");
                Option wait = OptionBuilder.create((String)WAIT);
                OptionBuilder.withArgName((String)USER);
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"use given userid to login into JEM");
                Option user = OptionBuilder.create((String)USER);
                host.setRequired(true);
                OptionBuilder.withArgName((String)PASSWORD);
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"use given password to login into JEM");
                Option pwd = OptionBuilder.create((String)PASSWORD);
                parser = new ArgumentsParser(HttpSubmit.class.getName(), jcl, type, host, user, pwd, wait);
            }
            Properties properties = parser.parseArg(args);
            cc.jclUrl = properties.getProperty(JCL);
            cc.hostForJemWeb = properties.getProperty(HOST);
            cc.jclType = properties.getProperty(TYPE);
            cc.passwordValue = properties.getProperty(PASSWORD);
            cc.userValue = properties.getProperty(USER);
            cc.wait = properties.containsKey(WAIT);
            if (cc.passwordValue == null) {
                CmdConsole console = new CmdConsole();
                cc.passwordValue = console.readPassword(cc.userValue);
            }
            rc = cc.submitJob();
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC033E, e);
            rc = 1;
        }
        return rc;
    }

    public static void main(String[] args) {
        int rc = HttpSubmit.executeCommand(args);
        System.exit(rc);
    }
}

