/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.commands;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.commands.util.ConfsUpdater;
import org.pepstock.jem.commands.util.NodeAttributes;
import org.pepstock.jem.commands.util.NodeProperties;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.keystore.KeyStoreInfo;
import org.pepstock.jem.node.security.keystore.KeyStoreUtil;

public class CreateNode {
    private static final String PROPERTIES = "properties";

    public static void main(String[] args) throws Exception {
        NodeAttributes nodeAttributes = CreateNode.checkArguments(args);
        nodeAttributes.init();
        if (nodeAttributes.getNodeDir().exists()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC060E, nodeAttributes.getNodeDir().getAbsolutePath());
            throw new Exception(NodeMessage.JEMC060E.toMessage().getFormattedMessage(nodeAttributes.getNodeDir().getAbsolutePath()));
        }
        if (nodeAttributes.getEnvDir().exists()) {
            CreateNode.createNode(nodeAttributes);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC059I, "Node", nodeAttributes.getNodeDir().getAbsolutePath());
        } else {
            CreateNode.createEnvironment(nodeAttributes);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC059I, "Environmnet", nodeAttributes.getEnvDir().getAbsolutePath());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC059I, "Node", nodeAttributes.getNodeDir().getAbsolutePath());
        }
    }

    private static void createEnvironment(NodeAttributes nodeAttributes) throws Exception {
        NodeProperties np = nodeAttributes.getNodeProperties();
        File srcDir = nodeAttributes.getTemplateEnvDirectory();
        File destDir = nodeAttributes.getEnvDir();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        File srcGfsConfigDir = nodeAttributes.getTemplateGfsConfigDirectory();
        File destGfsConfigDir = nodeAttributes.getGfsConfigDirectory();
        FileUtils.copyDirectory((File)srcGfsConfigDir, (File)destGfsConfigDir);
        File newNodeDir = new File(nodeAttributes.getEnvDir() + "/" + "nodename");
        boolean isRenamed = newNodeDir.renameTo(nodeAttributes.getNodeDir());
        if (!isRenamed) {
            throw new Exception(NodeMessage.JEMC154E.toMessage().getFormattedMessage(new Object[0]));
        }
        ConfsUpdater confs = new ConfsUpdater(nodeAttributes);
        confs.updateEnvConfigs();
        confs.updateNodeConfigs();
        new File(np.getPersistencePath() + "/" + np.getEnvironmentName() + "/" + "keystores").mkdir();
        File keystoreFile = new File(np.getPersistencePath() + "/" + np.getEnvironmentName() + "/" + "keystores" + "/" + np.getKeystoreName());
        KeyStoreInfo clusterkeystoreInfo = new KeyStoreInfo("JCEKS");
        clusterkeystoreInfo.setFile(keystoreFile);
        clusterkeystoreInfo.setBackupFile(new File(keystoreFile.getAbsolutePath() + ".backup"));
        clusterkeystoreInfo.setPassword(np.getKeystorePwd());
        clusterkeystoreInfo.setSymmetricKeyAlias(np.getEnvironmentName());
        clusterkeystoreInfo.setSymmetricKeyPwd(np.getCryptKeyPwd());
        KeyStoreUtil.generate(clusterkeystoreInfo);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC059I, "cluster Keystore", keystoreFile.getAbsolutePath());
        File usekeystoreFile = new File(np.getPersistencePath() + "/" + np.getEnvironmentName() + "/" + "keystores" + "/" + np.getUserKeystoreName());
        KeyStoreInfo userkeystoreInfo = new KeyStoreInfo("JKS");
        userkeystoreInfo.setFile(usekeystoreFile);
        userkeystoreInfo.setBackupFile(new File(usekeystoreFile.getAbsolutePath() + ".backup"));
        userkeystoreInfo.setPassword(np.getKeystorePwd());
        KeyStoreUtil.generate(userkeystoreInfo);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC059I, "users Keystore", usekeystoreFile.getAbsolutePath());
        CreateNode.zipDirectory(nodeAttributes.getWarDir(), nodeAttributes.getWarFile());
        FileUtils.deleteDirectory((File)nodeAttributes.getWarDir());
    }

    private static void createNode(NodeAttributes nodeAttributes) throws Exception {
        File srcDir = nodeAttributes.getTemplateNodeDirectory();
        File destDir = nodeAttributes.getNodeDir();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        ConfsUpdater confs = new ConfsUpdater(nodeAttributes);
        confs.updateNodeConfigs();
    }

    private static NodeAttributes checkArguments(String[] args) throws Exception {
        String jemHome = System.getenv().get("JEM_HOME");
        if (jemHome == null) {
            throw new Exception(NodeMessage.JEMC058E.toMessage().getFormattedMessage("JEM_HOME"));
        }
        OptionBuilder.withArgName((String)PROPERTIES);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The path of the properties file for the configuration of a new node/foder. See template create_node.properties inside JEM_HOME/config");
        Option propFile = OptionBuilder.create((String)PROPERTIES);
        propFile.setRequired(true);
        ArgumentsParser parser = new ArgumentsParser(CreateNode.class.getName(), propFile);
        Properties properties = parser.parseArg(args);
        String propertyUrlPath = properties.getProperty(PROPERTIES);
        URL url = null;
        try {
            url = new URL(propertyUrlPath);
        }
        catch (MalformedURLException ex) {
            File jcl = new File(propertyUrlPath);
            url = jcl.toURI().toURL();
        }
        Properties props = new Properties();
        props.load(url.openStream());
        NodeProperties np = new NodeProperties(props);
        np.checkMandatoryTag();
        return new NodeAttributes(jemHome, np);
    }

    private static void zipDirectory(File directoryPath, File zipPath) throws IOException {
        FileOutputStream fOut = new FileOutputStream(zipPath);
        BufferedOutputStream bOut = new BufferedOutputStream(fOut);
        ZipArchiveOutputStream tOut = new ZipArchiveOutputStream((OutputStream)bOut);
        CreateNode.zip(directoryPath, directoryPath, tOut);
        tOut.finish();
        tOut.close();
        bOut.close();
        fOut.close();
    }

    private static final void zip(File directory, File base, ZipArchiveOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                CreateNode.zip(files[i], base, zos);
                continue;
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(files[i]);
                ZipArchiveEntry entry = new ZipArchiveEntry(files[i].getPath().substring(base.getPath().length() + 1));
                zos.putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)in, (OutputStream)zos);
                zos.closeArchiveEntry();
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }
}

