/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.validator.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.bind.ValidationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.pepstock.jem.ant.AntJcl;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.validator.transformer.TransformerErrorListner;
import org.pepstock.jem.ant.validator.transformer.TransformerFactoryErrorListner;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

public class TransformerValidator
extends FileAlterationListenerAdaptor {
    private String xsltFile = null;
    private Transformer transformer = null;
    private FileAlterationMonitor monitor = null;
    private FileAlterationObserver observer = null;

    public void load(String xsltValidatorFile) throws ValidationException {
        this.verifyXsltFile(xsltValidatorFile);
        this.createFileListner(xsltValidatorFile);
        try {
            this.renewTransformer(xsltValidatorFile);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
    }

    private synchronized void renewTransformer(String xsltvalidatorFile) throws ValidationException {
        this.transformer = this.createTransformer(xsltvalidatorFile);
        LogAppl.getInstance().emit((MessageInterface)AntMessage.JEMA051I, xsltvalidatorFile);
    }

    private Transformer createTransformer(String xsltvalidatorFile) throws ValidationException {
        Transformer t = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        TransformerFactoryErrorListner tfel = new TransformerFactoryErrorListner();
        tFactory.setErrorListener(tfel);
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new ValidationException(AntMessage.JEMA050E.toMessage().getFormattedMessage(new Object[0]));
        }
        tFactory.setAttribute("http://xml.apache.org/xalan/properties/source-location", Boolean.TRUE);
        StreamSource ss = new StreamSource(xsltvalidatorFile);
        try {
            t = tFactory.newTransformer(ss);
        }
        catch (TransformerConfigurationException e) {
            throw new ValidationException(AntMessage.JEMA047E.toMessage().getFormattedMessage(e.getMessage()));
        }
        TransformerErrorListner el = new TransformerErrorListner();
        t.setErrorListener(el);
        for (Object object : System.getProperties().keySet()) {
            String keyString = object.toString();
            String value = System.getProperty(keyString);
            t.setParameter(keyString, value);
        }
        for (String string : System.getenv().keySet()) {
            String value = System.getenv().get(string);
            t.setParameter(string, value);
        }
        return t;
    }

    private void createFileListner(String xsltvalidatorFile) throws ValidationException {
        try {
            if (this.monitor == null) {
                this.monitor = new FileAlterationMonitor();
            } else {
                this.monitor.stop();
            }
            if (this.observer != null) {
                this.monitor.removeObserver(this.observer);
                this.observer.removeListener((FileAlterationListener)this);
                this.observer.destroy();
                this.observer = null;
            }
            File f = new File(xsltvalidatorFile);
            String fDir = f.getParent();
            String fName = f.getName();
            IOFileFilter filter = FileFilterUtils.nameFileFilter((String)fName);
            this.observer = new FileAlterationObserver(fDir, (FileFilter)filter);
            this.observer.addListener((FileAlterationListener)this);
            this.monitor.addObserver(this.observer);
            this.monitor.start();
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
    }

    public void validate(AntJcl jcl) throws ValidationException {
        if (jcl == null) {
            throw new ValidationException("the jcl to validate is null");
        }
        this.transform(jcl.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void transform(String inXmlContent) throws ValidationException {
        TransformerValidator transformerValidator = this;
        synchronized (transformerValidator) {
            StreamSource source = null;
            StreamResult result = null;
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(inXmlContent.getBytes());
                source = new StreamSource(is);
                StringWriter sw = new StringWriter();
                result = new StreamResult(sw);
                this.transformer.transform(source, result);
                sw.close();
            }
            catch (TransformerConfigurationException e) {
                throw new ValidationException((Throwable)e);
            }
            catch (TransformerException e) {
                throw new ValidationException(e.getMessageAndLocation());
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e);
            }
        }
    }

    public void verifyXsltFile(String file) throws ValidationException {
        if (file == null || file.isEmpty()) {
            throw new ValidationException(AntMessage.JEMA049E.toMessage().getFormattedMessage("null or empty"));
        }
        File f = new File(file);
        if (!f.exists()) {
            throw new ValidationException(AntMessage.JEMA048E.toMessage().getFormattedMessage(file));
        }
        if (!f.isFile()) {
            throw new ValidationException(AntMessage.JEMA049E.toMessage().getFormattedMessage(file));
        }
        try {
            this.xsltFile = f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public void onFileChange(File file) {
        try {
            if (file.getCanonicalPath().equals(this.xsltFile)) {
                this.renewTransformer(file.getCanonicalPath());
            }
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

