/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities.sort;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Scanner;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;

public class DefaultComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DATA_DESCRIPTION_NAME = "COMMAND";
    private static MessageFormat mf1 = new MessageFormat("({0,number,integer})");
    private static MessageFormat mf2 = new MessageFormat("({0,number,integer},{1,number,integer})");
    private static MessageFormat mf1andStr = new MessageFormat("({0,number,integer},{1})");
    private static MessageFormat mf2andStr = new MessageFormat("({0,number,integer},{1,number,integer},{2})");
    private LinkedList<SingleComparator> comparators = new LinkedList();

    public DefaultComparator() throws Exception {
        try {
            InitialContext ic = ContextUtils.getContext();
            Object filein = ic.lookup(DATA_DESCRIPTION_NAME);
            StringBuffer recordsSB = this.read((InputStream)filein);
            String records = recordsSB.toString().trim();
            this.loadCommands(records);
        }
        catch (NamingException e) {
            System.out.println(AntMessage.JEMA044W.toMessage().getFormattedMessage(e.getMessage()));
        }
    }

    @Override
    public int compare(String o1, String o2) {
        if (!this.comparators.isEmpty()) {
            for (SingleComparator c : this.comparators) {
                String partO2;
                String partO1 = c.getLength() > 0 ? o1.substring(c.getStart(), c.getStart() + c.getLength() - 1) : o1.substring(c.getStart());
                int compareResult = partO1.compareToIgnoreCase(partO2 = c.getLength() > 0 ? o2.substring(c.getStart(), c.getStart() + c.getLength() - 1) : o2.substring(c.getStart()));
                if (compareResult == 0) continue;
                compareResult = c.getMode().equalsIgnoreCase("ASC") ? compareResult * 1 : compareResult * -1;
                return compareResult;
            }
            return 0;
        }
        return o1.compareToIgnoreCase(o2);
    }

    private void loadCommands(String records) throws ParseException {
        Object[] s = StringUtils.split((String)records, (String)" ");
        String commandLine = StringUtils.join((Object[])s);
        System.out.println(AntMessage.JEMA045I.toMessage().getFormattedMessage(commandLine));
        String[] s1 = StringUtils.splitByWholeSeparator((String)commandLine, (String)"),");
        for (int i = 0; i < s1.length; ++i) {
            Object[] result = null;
            String command = s1[i].endsWith(")") ? s1[i] : s1[i] + ")";
            try {
                result = mf1.parse(command);
            }
            catch (ParseException e) {
                try {
                    result = mf2.parse(command);
                }
                catch (ParseException e1) {
                    try {
                        result = mf2andStr.parse(command);
                    }
                    catch (ParseException e2) {
                        try {
                            result = mf1andStr.parse(command);
                        }
                        catch (ParseException e3) {
                            System.out.println(AntMessage.JEMA046W.toMessage().getFormattedMessage(command, e3.getMessage()));
                            throw e3;
                        }
                    }
                }
            }
            if (result == null) continue;
            try {
                SingleComparator c = this.createSingleComparator(result);
                this.comparators.addLast(c);
                continue;
            }
            catch (ParseException e) {
                System.out.println(AntMessage.JEMA046W.toMessage().getFormattedMessage(command, e.getMessage()));
                throw e;
            }
        }
    }

    private SingleComparator createSingleComparator(Object[] result) throws ParseException {
        String value;
        SingleComparator c = new SingleComparator();
        if (!(result[0] instanceof Number)) {
            throw new ParseException("First parameter is not a Number", 0);
        }
        Number n = (Number)result[0];
        c.setStart(n.intValue());
        if (result.length == 2) {
            if (result[1] instanceof Number) {
                n = (Number)result[1];
                c.setLength(n.intValue());
            } else {
                value = result[1].toString();
                if (!value.equalsIgnoreCase("ASC") && !value.equalsIgnoreCase("DESC")) {
                    throw new ParseException("Invalid format for sorting mode definition: must be ASC or DESC", 1);
                }
                c.setMode(value);
            }
        } else if (result.length == 3) {
            if (!(result[1] instanceof Number)) {
                throw new ParseException("First parameter is not a Number", 1);
            }
            n = (Number)result[1];
            c.setLength(n.intValue());
            value = result[2].toString();
            if (!value.equalsIgnoreCase("ASC") && !value.equalsIgnoreCase("DESC")) {
                throw new ParseException("Invalid format for sorting mode definition: must be ASC or DESC", 2);
            }
            c.setMode(value);
        } else {
            throw new ParseException("Invalid format for sorting definition: max length is 3 but is " + result.length, 0);
        }
        return c;
    }

    private StringBuffer read(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        while (sc.hasNext()) {
            String record = sc.next().toString();
            sb.append(record.trim()).append(' ');
        }
        sc.close();
        return sb;
    }

    static class SingleComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int ZERO = 0;
        public static final String ASC = "ASC";
        public static final String DESC = "DESC";
        private int start = 0;
        private int length = 0;
        private String mode = "ASC";

        SingleComparator() {
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }
}

