/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.tools.ant.BuildException;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.StepJava;
import org.pepstock.jem.ant.tasks.utilities.BinaryFileBuffer;
import org.pepstock.jem.ant.tasks.utilities.sort.DefaultComparator;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;

public class SortTask
extends StepJava {
    private static int DEFAULTMAXTEMPFILES = 1024;
    private static final String INPUT_DATA_DESCRIPTION_NAME = "INPUT";
    private static final String OUTPUT_DATA_DESCRIPTION_NAME = "OUTPUT";
    private static String CLASS = "class";

    @Override
    public void execute() throws BuildException {
        boolean input = false;
        boolean output = false;
        for (DataDescription dd : super.getDataDescriptions()) {
            if (dd.getName().equalsIgnoreCase(INPUT_DATA_DESCRIPTION_NAME)) {
                input = true;
            }
            if (!dd.getName().equalsIgnoreCase(OUTPUT_DATA_DESCRIPTION_NAME)) continue;
            output = true;
        }
        if (!input) {
            throw new BuildException(AntMessage.JEMA018E.toMessage().getFormattedMessage(INPUT_DATA_DESCRIPTION_NAME));
        }
        if (!output) {
            throw new BuildException(AntMessage.JEMA018E.toMessage().getFormattedMessage(OUTPUT_DATA_DESCRIPTION_NAME));
        }
        super.setClassname(SortTask.class.getName());
        super.execute();
    }

    public static long estimateBestSizeOfBlocks(FileInputStream filetobesorted, int maxtmpfiles) throws IOException {
        long freemem;
        long sizeoffile = filetobesorted.getChannel().size() * 2L;
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < (freemem = Runtime.getRuntime().freeMemory()) / 2L) {
            blocksize = freemem / 2L;
        }
        return blocksize;
    }

    public static List<File> sortInBatch(FileInputStream fileInput, Comparator<String> cmp) throws IOException {
        return SortTask.sortInBatch(fileInput, cmp, DEFAULTMAXTEMPFILES, Charset.defaultCharset(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> sortInBatch(FileInputStream fileInput, Comparator<String> cmp, int maxtmpfiles, Charset cs, File tmpdirectory) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)fileInput, cs));
        long blocksize = SortTask.estimateBestSizeOfBlocks(fileInput, maxtmpfiles);
        try {
            ArrayList<String> tmplist = new ArrayList<String>();
            String line = "";
            try {
                while (line != null) {
                    for (long currentblocksize = 0L; currentblocksize < blocksize && (line = fbr.readLine()) != null; currentblocksize += (long)(line.length() * 2)) {
                        tmplist.add(line);
                    }
                    files.add(SortTask.sortAndSave(tmplist, cmp, cs, tmpdirectory));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(SortTask.sortAndSave(tmplist, cmp, cs, tmpdirectory));
                    tmplist.clear();
                }
            }
        }
        finally {
            fbr.close();
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs, File tmpdirectory) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", tmpdirectory);
        newtmpfile.deleteOnExit();
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newtmpfile), cs));
        try {
            for (String r : tmplist) {
                fbw.write(r);
                fbw.newLine();
            }
        }
        finally {
            fbw.close();
        }
        return newtmpfile;
    }

    public static int mergeSortedFiles(List<File> files, FileOutputStream fileOutput, Comparator<String> cmp) throws IOException {
        return SortTask.mergeSortedFiles(files, fileOutput, cmp, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mergeSortedFiles(List<File> files, FileOutputStream fileOutput, final Comparator<String> cmp, Charset cs) throws IOException {
        BinaryFileBuffer bfb;
        PriorityQueue<BinaryFileBuffer> pq = new PriorityQueue<BinaryFileBuffer>(11, new Comparator<BinaryFileBuffer>(){

            @Override
            public int compare(BinaryFileBuffer i, BinaryFileBuffer j) {
                return cmp.compare(i.peek(), j.peek());
            }
        });
        for (File f : files) {
            bfb = new BinaryFileBuffer(f, cs);
            pq.add(bfb);
        }
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutput, cs));
        int rowcounter = 0;
        try {
            while (pq.size() > 0) {
                bfb = pq.poll();
                String r = bfb.pop();
                fbw.write(r);
                fbw.newLine();
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.fbr.close();
                    boolean isDeleted = bfb.originalfile.delete();
                    if (isDeleted) continue;
                }
                pq.add(bfb);
            }
        }
        finally {
            fbw.close();
            for (BinaryFileBuffer bfb2 : pq) {
                bfb2.close();
            }
        }
        return rowcounter;
    }

    public static void main(String[] args) throws Exception {
        OptionBuilder.withArgName((String)CLASS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"class of Comparator<String> to invoke reading the objects");
        Option classArg = OptionBuilder.create((String)CLASS);
        classArg.setRequired(false);
        ArgumentsParser parser = new ArgumentsParser(SortTask.class.getName(), classArg);
        Properties properties = parser.parseArg(args);
        String classParam = properties.getProperty(CLASS);
        Comparator<String> comparator = null;
        if (classParam != null) {
            Object objectTL = Class.forName(classParam).newInstance();
            if (objectTL instanceof Comparator) {
                System.out.println(AntMessage.JEMA042I.toMessage().getFormattedMessage(objectTL.getClass().getName()));
                comparator = (Comparator)objectTL;
            } else {
                System.out.println(AntMessage.JEMA043I.toMessage().getFormattedMessage(new Object[0]));
                comparator = new DefaultComparator();
            }
        } else {
            System.out.println(AntMessage.JEMA043I.toMessage().getFormattedMessage(new Object[0]));
            comparator = new DefaultComparator();
        }
        int maxtmpfiles = DEFAULTMAXTEMPFILES;
        Charset cs = Charset.defaultCharset();
        InitialContext ic = ContextUtils.getContext();
        Object input = ic.lookup(INPUT_DATA_DESCRIPTION_NAME);
        Object output = ic.lookup(OUTPUT_DATA_DESCRIPTION_NAME);
        FileInputStream istream = null;
        FileOutputStream ostream = null;
        if (!(input instanceof FileInputStream)) {
            throw new Exception(AntMessage.JEMA017E.toMessage().getFormattedMessage(INPUT_DATA_DESCRIPTION_NAME, input.getClass().getName()));
        }
        istream = (FileInputStream)input;
        if (!(output instanceof FileOutputStream)) {
            throw new Exception(AntMessage.JEMA017E.toMessage().getFormattedMessage(OUTPUT_DATA_DESCRIPTION_NAME, output.getClass().getName()));
        }
        ostream = (FileOutputStream)output;
        if (istream.getChannel().size() > 0L) {
            List<File> l = SortTask.sortInBatch(istream, comparator, maxtmpfiles, cs, null);
            SortTask.mergeSortedFiles(l, ostream, comparator, cs);
        }
    }
}

