/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.tasks.StepExec;

public class ShellScriptTask
extends StepExec {
    private StringBuffer script = new StringBuffer();
    private String shell = null;
    private File temporaryScriptFile = null;
    private String suffix = null;

    public void addText(String line) {
        this.script.append(this.getProject().replaceProperties(line));
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public void setExecutable(String exec) {
        this.setShell(exec);
    }

    public void setCommand(Commandline commandLine) {
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.shell == null) {
            throw new BuildException(AntMessage.JEMA019E.toMessage().getFormattedMessage(new Object[0]));
        }
        try {
            this.writeScript();
            super.createArg().setValue(this.temporaryScriptFile.getAbsolutePath());
            super.setExecutable(this.shell);
            super.execute();
        }
        finally {
            boolean isDeleted;
            if (this.temporaryScriptFile == null || !(isDeleted = this.temporaryScriptFile.delete())) {
                // empty if block
            }
        }
    }

    protected void writeScript() throws BuildException {
        FileOutputStream os = null;
        try {
            this.temporaryScriptFile = File.createTempFile("script", this.suffix, null);
            this.temporaryScriptFile.deleteOnExit();
            os = new FileOutputStream(this.temporaryScriptFile);
            String string = this.script.toString();
            os.write(string.getBytes(), 0, string.length());
            os.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (Throwable t) {}
        }
    }
}

