/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.tasks.StepExec;

public class ExecBinaryTask
extends StepExec {
    private static final String SHELL_UNIX = "bash";
    private static final String ARG_0_UNIX = "-c";
    private static final String SHELL_WINDOWS = "cmd.exe";
    private static final String ARG_0_WINDOWS = "/c";
    private String executable = null;

    public void setExecutable(String exec) {
        this.executable = exec;
    }

    public void setCommand(Commandline commandLine) {
        throw new BuildException(AntMessage.JEMA054E.toMessage().getFormattedMessage(new Object[0]));
    }

    @Override
    public void execute() throws BuildException {
        if (this.executable == null) {
            throw new BuildException(AntMessage.JEMA055E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (SystemUtils.IS_OS_UNIX) {
            this.loadUnixEnv();
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.loadWindowsEnv();
        } else {
            throw new BuildException(AntMessage.JEMA056E.toMessage().getFormattedMessage(SystemUtils.OS_NAME));
        }
        this.log(this.cmdl.describeCommand());
        super.execute();
    }

    private void loadWindowsEnv() {
        super.setExecutable(SHELL_WINDOWS);
        this.cmdl.createArgument(true).setValue(this.normalizeExecutable());
        this.cmdl.createArgument(true).setValue(ARG_0_WINDOWS);
    }

    private void loadUnixEnv() {
        super.setExecutable(SHELL_UNIX);
        this.cmdl.createArgument(true).setValue(this.normalizeExecutable());
        this.cmdl.createArgument(true).setValue(ARG_0_UNIX);
    }

    private String normalizeExecutable() throws BuildException {
        String binaryPath = System.getProperty("jem.binary");
        if (binaryPath == null) {
            throw new BuildException(AntMessage.JEMA053E.toMessage().getFormattedMessage(new Object[0]));
        }
        binaryPath = FilenameUtils.normalize((String)binaryPath, (boolean)true);
        File file = null;
        if (this.executable.startsWith(binaryPath)) {
            file = new File(this.executable);
        } else {
            file = new File(this.executable);
            if (!FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true).equalsIgnoreCase(this.executable)) {
                file = new File(binaryPath, this.executable);
            }
        }
        return FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
    }
}

