/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.naming.InitialContext;
import org.apache.tools.ant.BuildException;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.StepJava;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;

public class CopyTask
extends StepJava {
    private static final int BUF_SIZE = 8192;
    private static final String INPUT_DATA_DESCRIPTION_NAME = "INPUT";
    private static final String OUTPUT_DATA_DESCRIPTION_NAME = "OUTPUT";

    @Override
    public void execute() throws BuildException {
        boolean input = false;
        boolean output = false;
        for (DataDescription dd : super.getDataDescriptions()) {
            if (dd.getName().equalsIgnoreCase(INPUT_DATA_DESCRIPTION_NAME)) {
                input = true;
            }
            if (!dd.getName().equalsIgnoreCase(OUTPUT_DATA_DESCRIPTION_NAME)) continue;
            output = true;
        }
        if (!input) {
            throw new BuildException(AntMessage.JEMA018E.toMessage().getFormattedMessage(INPUT_DATA_DESCRIPTION_NAME));
        }
        if (!output) {
            throw new BuildException(AntMessage.JEMA018E.toMessage().getFormattedMessage(OUTPUT_DATA_DESCRIPTION_NAME));
        }
        super.setClassname(CopyTask.class.getName());
        super.execute();
    }

    public static void main(String[] args) throws Exception {
        InitialContext ic = ContextUtils.getContext();
        Object input = ic.lookup(INPUT_DATA_DESCRIPTION_NAME);
        Object output = ic.lookup(OUTPUT_DATA_DESCRIPTION_NAME);
        InputStream istream = null;
        OutputStream ostream = null;
        if (!(input instanceof InputStream)) {
            throw new Exception(AntMessage.JEMA017E.toMessage().getFormattedMessage(INPUT_DATA_DESCRIPTION_NAME, input.getClass().getName()));
        }
        istream = (InputStream)input;
        if (!(output instanceof OutputStream)) {
            throw new Exception(AntMessage.JEMA016E.toMessage().getFormattedMessage(OUTPUT_DATA_DESCRIPTION_NAME, output.getClass().getName()));
        }
        ostream = (OutputStream)output;
        if (istream instanceof FileInputStream) {
            FileChannel ichannel = ((FileInputStream)istream).getChannel();
            ichannel.transferTo(0L, ichannel.size(), Channels.newChannel(ostream));
            ichannel.close();
        } else if (ostream instanceof FileOutputStream) {
            FileChannel ochannel = ((FileOutputStream)ostream).getChannel();
            ochannel.transferFrom(Channels.newChannel(istream), 0L, Long.MAX_VALUE);
            ochannel.close();
        } else {
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                ostream.write(buffer, 0, count);
            } while ((count = istream.read(buffer, 0, buffer.length)) != -1);
            ostream.close();
            istream.close();
        }
    }
}

