/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.utilities;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

class BinaryFileBuffer {
    public static int BUFFERSIZE = 2048;
    public BufferedReader fbr;
    public File originalfile;
    private String cache;
    private boolean empty;

    public BinaryFileBuffer(File f, Charset cs) throws IOException {
        this.originalfile = f;
        this.fbr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), cs), BUFFERSIZE);
        this.reload();
    }

    public boolean empty() {
        return this.empty;
    }

    private void reload() throws IOException {
        try {
            this.cache = this.fbr.readLine();
            if (this.cache == null) {
                this.empty = true;
                this.cache = null;
            } else {
                this.empty = false;
            }
        }
        catch (EOFException oef) {
            this.empty = true;
            this.cache = null;
        }
    }

    public void close() throws IOException {
        this.fbr.close();
    }

    public String peek() {
        if (this.empty()) {
            return null;
        }
        return this.cache.toString();
    }

    public String pop() throws IOException {
        String answer = this.peek();
        this.reload();
        return answer;
    }
}

