/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.managers;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.pepstock.jem.ant.DataDescriptionStep;

public class ReturnCodesContainer {
    private static final String level_separator = ".";
    private static final int level_without_id = 2;
    private static final int level_with_id = 3;
    private static final MessageFormat mf = new MessageFormat("{0}.{1}.{2}");
    private static ReturnCodesContainer CONTAINER = null;
    private HashMap<String, Integer> mapReturnCodes = new HashMap();

    public static ReturnCodesContainer getInstance() {
        if (CONTAINER == null) {
            CONTAINER = new ReturnCodesContainer();
        }
        return CONTAINER;
    }

    private ReturnCodesContainer() {
    }

    public boolean hasReturnCode(DataDescriptionStep step) {
        return this.hasReturnCode(this.createKey(step));
    }

    public Integer getReturnCode(DataDescriptionStep step) {
        return this.getReturnCode(this.createKey(step));
    }

    public boolean hasReturnCode(String reference) {
        String ref = this.normalizeReference(reference);
        return ref != null ? this.mapReturnCodes.containsKey(ref.toLowerCase()) : false;
    }

    public Integer getReturnCode(String reference) {
        String ref = this.normalizeReference(reference);
        return ref != null ? this.mapReturnCodes.get(ref.toLowerCase()) : null;
    }

    public void setReturnCode(Project project, DataDescriptionStep item, Integer rc) {
        String key = this.createKey(item);
        this.mapReturnCodes.put(key, rc);
        PropertyHelper.getPropertyHelper((Project)project).setNewProperty(key, (Object)rc);
    }

    private String createKey(DataDescriptionStep item) {
        String key = mf.format(new Object[]{item.getTargetName(), item.getTaskName(), item.getId()}, new StringBuffer(), (FieldPosition)null).toString();
        return key.toLowerCase();
    }

    private String normalizeReference(String reference) {
        String[] levels = StringUtils.split((String)reference, (String)level_separator);
        if (levels != null) {
            if (levels.length == 3) {
                return reference;
            }
            if (levels.length == 2) {
                reference = levels[0] + level_separator + levels[1] + level_separator + "1";
                return reference;
            }
        }
        return null;
    }

    public String toString() {
        return this.mapReturnCodes.toString();
    }
}

