/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.Lock;
import org.pepstock.jem.ant.tasks.managers.DataDescriptionManager;
import org.pepstock.jem.ant.tasks.managers.ImplementationsContainer;
import org.pepstock.jem.ant.tasks.managers.StepsContainer;
import org.pepstock.jem.node.ResourceLock;
import org.pepstock.jem.node.rmi.ResourceLocker;
import org.pepstock.jem.node.tasks.InitiatorManager;

public class Locker {
    private ArrayList<ResourceLock> resources = new ArrayList();
    private ResourceLocker locker = InitiatorManager.getResourceLocker();

    public Locker() throws Exception {
        ImplementationsContainer.getInstance();
    }

    public void lock() throws Exception {
        Collections.sort(StepsContainer.getInstance().getDataDescriptionSteps(), new Comparator<DataDescriptionStep>(){

            @Override
            public int compare(DataDescriptionStep arg0, DataDescriptionStep arg1) {
                return arg0.getOrder() - arg1.getOrder();
            }
        });
        for (DataDescriptionStep item : StepsContainer.getInstance().getDataDescriptionSteps()) {
            this.load(item);
        }
        if (!this.resources.isEmpty()) {
            this.locker.lock(this.resources);
        }
    }

    private void load(DataDescriptionStep item) throws Exception {
        for (DataDescription dd : item.getDataDescriptions()) {
            DataDescriptionImpl ddImpl = DataDescriptionManager.createDataDescriptionImpl(dd, item);
            InitiatorManager.addResourcesLock(ddImpl, this.resources);
        }
        for (Lock lock : item.getLocks()) {
            if (lock.getName() == null) continue;
            ResourceLock rLock = new ResourceLock(lock.getName(), 1);
            this.resources.add(rLock);
        }
    }

    public void unlock() throws Exception {
        if (!this.resources.isEmpty()) {
            this.locker.unlock();
            this.resources.clear();
            StepsContainer.getInstance().getDataDescriptionSteps().clear();
        }
    }
}

