/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.managers;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.jem.ant.DataDescriptionStep;

public class ImplementationsContainer {
    private static final String level_separator = ".";
    private static final int level_with_id = 5;
    private static final int level_without_id = 4;
    private static final MessageFormat mf = new MessageFormat("*.{0}.{1}.{2}.{3}");
    private static final MessageFormat mf4search = new MessageFormat("*.{0}.{1}.{2}.");
    private static ImplementationsContainer CONTAINER = null;
    private HashMap<String, DataDescriptionImpl> mapDataDescription = new HashMap();

    public static ImplementationsContainer getInstance() {
        if (CONTAINER == null) {
            CONTAINER = new ImplementationsContainer();
        }
        return CONTAINER;
    }

    private ImplementationsContainer() {
    }

    public boolean hasDataDescription(String reference) {
        String ref = this.normalizeReference(reference);
        return ref != null ? this.mapDataDescription.containsKey(ref.toLowerCase()) : false;
    }

    public DataDescriptionImpl getDataDescription(String reference) {
        String ref = this.normalizeReference(reference);
        return ref != null ? this.mapDataDescription.get(ref.toLowerCase()) : null;
    }

    public List<DataDescriptionImpl> getDataDescriptionsByItem(DataDescriptionStep item) {
        ArrayList<DataDescriptionImpl> result = new ArrayList<DataDescriptionImpl>();
        String keyPattern = this.createKey(item);
        for (String key : this.mapDataDescription.keySet()) {
            if (!key.startsWith(keyPattern)) continue;
            result.add(this.mapDataDescription.get(key));
        }
        return result;
    }

    public void addDataDescription(DataDescriptionStep item, DataDescriptionImpl dd) {
        String key = this.createKey(item, dd.getName());
        this.mapDataDescription.put(key, dd);
    }

    private String createKey(DataDescriptionStep item, String ddname) {
        String key = mf.format(new Object[]{item.getTargetName(), item.getTaskName(), item.getId(), ddname}, new StringBuffer(), (FieldPosition)null).toString();
        return key.toLowerCase();
    }

    private String createKey(DataDescriptionStep item) {
        String key = mf4search.format(new Object[]{item.getTargetName(), item.getTaskName(), item.getId()}, new StringBuffer(), (FieldPosition)null).toString();
        return key.toLowerCase();
    }

    private String normalizeReference(String reference) {
        String[] levels = StringUtils.split((String)reference, (String)level_separator);
        if (levels != null) {
            if (levels.length == 5) {
                return reference;
            }
            if (levels.length == 4) {
                reference = levels[0] + level_separator + levels[1] + level_separator + levels[2] + level_separator + "1" + level_separator + levels[3];
                return reference;
            }
        }
        return null;
    }

    public String toString() {
        return this.mapDataDescription.toString();
    }
}

