/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.managers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.DataSet;
import org.pepstock.jem.ant.tasks.managers.FileWrapper;
import org.pepstock.jem.ant.tasks.managers.ImplementationsContainer;
import org.pepstock.jem.node.NodeMessage;

public class DataSetManager {
    public static final String INLINE_FILE_NAME_PREFIX = "step-inline";

    public static void loadReferences(DataDescriptionImpl ddImpl, DataSet ds) throws BuildException {
        DataDescriptionImpl referback;
        if (ds.isReference()) {
            ImplementationsContainer container = ImplementationsContainer.getInstance();
            if (ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                throw new BuildException(AntMessage.JEMA009E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
            }
            if (!container.hasDataDescription(ds.getName())) {
                throw new BuildException(AntMessage.JEMA010E.toMessage().getFormattedMessage(ddImpl.getName(), ds.getName()));
            }
            referback = container.getDataDescription(ds.getName());
            if (referback.getDataSetsImpl().size() > 1 && !ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
                throw new BuildException(AntMessage.JEMA009E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
            }
            for (DataSetImpl dataset : referback.getDataSetsImpl()) {
                File file = dataset.getFile();
                if (!file.exists()) {
                    throw new BuildException(AntMessage.JEMA011E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()), (Throwable)new FileNotFoundException(file.getAbsolutePath()));
                }
                ddImpl.addDataSetImpl(dataset);
            }
        } else {
            throw new BuildException(AntMessage.JEMA012E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
        }
        ddImpl.setDataDescriptionReference(referback);
    }

    public static void createDataSetImpl(DataDescriptionImpl ddImpl, DataSet ds, DataDescriptionStep item) throws IOException, BuildException {
        DataSetImpl dataset = new DataSetImpl();
        if (ds.isReference()) {
            throw new BuildException(AntMessage.JEMA012E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
        }
        if (ds.isTemporary()) {
            if (!ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                throw new BuildException(AntMessage.JEMA013E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
            }
            if (ds.getName() == null) {
                throw new BuildException(AntMessage.JEMA014E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            dataset.setName(ds.getName());
            File file = File.createTempFile(ds.getName().substring(2), ".tmp");
            file.deleteOnExit();
            dataset.setFile(file);
            dataset.setType(1);
        } else if (ds.isInline()) {
            dataset.setName(ds.getName());
            File file = File.createTempFile(INLINE_FILE_NAME_PREFIX, ".tmp");
            file.deleteOnExit();
            PrintStream ps = new PrintStream(file);
            ps.print(item.getProject().replaceProperties(ds.getText().toString()));
            ps.close();
            dataset.setFile(file);
            dataset.setType(2);
        } else if (ds.isGdg()) {
            if (ds.getName() == null) {
                throw new BuildException(AntMessage.JEMA014E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            FileWrapper fileWrapper = DataSetManager.getFile(ddImpl, ds);
            File file = fileWrapper.getFile();
            dataset.setName(fileWrapper.getDataSetName());
            dataset.setType(4);
            dataset.setFile(file);
            dataset.setOffset(ds.getOffset());
        } else if (ds.isDatasource()) {
            dataset.setType(6);
            dataset.setDataSource(ds.getDatasource());
            dataset.setName(ds.getName());
        } else {
            if (ds.getName() == null) {
                throw new BuildException(AntMessage.JEMA014E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            FileWrapper fileWrapper = DataSetManager.getFile(ddImpl, ds);
            File file = fileWrapper.getFile();
            dataset.setName(fileWrapper.getDataSetName());
            if (ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                boolean isCreated;
                if (file.exists()) {
                    throw new BuildException(AntMessage.JEMA013E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
                }
                File parent = file.getParentFile();
                if (!parent.exists() && !(isCreated = parent.mkdirs())) {
                    throw new BuildException(NodeMessage.JEMC153E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
                }
            } else if (!file.exists()) {
                throw new BuildException(AntMessage.JEMA010E.toMessage().getFormattedMessage(ddImpl.getName(), ds.getName()));
            }
            dataset.setType(0);
            dataset.setFile(file);
        }
        ddImpl.addDataSetImpl(dataset);
    }

    private static FileWrapper getFile(DataDescriptionImpl ddImpl, DataSet ds) throws BuildException {
        String dataPath = System.getProperty("jem.data");
        if (dataPath == null) {
            throw new BuildException(AntMessage.JEMA001E.toMessage().getFormattedMessage(new Object[0]));
        }
        dataPath = FilenameUtils.normalize((String)dataPath, (boolean)true);
        File file = null;
        String fileName = null;
        if (ds.getName().startsWith(dataPath)) {
            file = new File(ds.getName());
            fileName = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
            fileName = StringUtils.substringAfter((String)fileName, (String)dataPath);
            fileName = fileName.substring(1);
        } else {
            file = new File(ds.getName());
            if (FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true).equalsIgnoreCase(ds.getName())) {
                fileName = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
            } else {
                file = new File(dataPath, ds.getName());
                fileName = FilenameUtils.normalize((String)ds.getName(), (boolean)true);
            }
        }
        return new FileWrapper(file, fileName);
    }
}

