/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks.managers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.DataSet;
import org.pepstock.jem.ant.tasks.StepExec;
import org.pepstock.jem.ant.tasks.managers.DataSetManager;
import org.pepstock.jem.ant.tasks.managers.ImplementationsContainer;
import org.pepstock.jem.node.NodeMessage;

public class DataDescriptionManager {
    public static DataDescriptionImpl createDataDescriptionImpl(DataDescription dd, DataDescriptionStep item) throws BuildException, IOException {
        if (dd.getName() == null) {
            throw new BuildException(AntMessage.JEMA005E.toMessage().getFormattedMessage(new Object[0]));
        }
        DataDescriptionImpl ddImpl = new DataDescriptionImpl();
        ddImpl.setName(dd.getName());
        ddImpl.setDisposition(dd.getDisposition());
        if (dd.isSysout()) {
            DataDescriptionManager.loadSysout(ddImpl, item);
        } else if (dd.isSingleDataset()) {
            DataDescriptionManager.loadSingleDataset(ddImpl, dd, item);
        } else if (dd.isMultiDataset()) {
            if (item instanceof StepExec) {
                throw new BuildException(AntMessage.JEMA006E.toMessage().getFormattedMessage(dd.getName(), dd.getDisposition()));
            }
            DataDescriptionManager.loadMultiDataset(ddImpl, dd, item);
        }
        return ddImpl;
    }

    private static void loadSysout(DataDescriptionImpl ddImpl, DataDescriptionStep item) throws BuildException {
        boolean isCreated;
        ddImpl.setSysout(true);
        String path = System.getProperty("jem.output");
        if (path == null) {
            throw new BuildException(AntMessage.JEMA007E.toMessage().getFormattedMessage(new Object[0]));
        }
        File dir = new File(path, item.getTargetName());
        if (!dir.exists() && !(isCreated = dir.mkdir())) {
            throw new BuildException(NodeMessage.JEMC153E.toMessage().getFormattedMessage(dir.getAbsolutePath()));
        }
        File file = new File(dir, item.getTaskName() + "-" + ddImpl.getName() + ".log");
        DataSet ds = new DataSet();
        ds.setName(item.getTaskName() + "-" + ddImpl.getName());
        DataSetImpl dataset = new DataSetImpl();
        dataset.setName(file.getName());
        dataset.setType(5);
        dataset.setFile(file);
        ddImpl.addDataSetImpl(dataset);
        ImplementationsContainer.getInstance().addDataDescription(item, ddImpl);
    }

    private static void loadSingleDataset(DataDescriptionImpl ddImpl, DataDescription dd, DataDescriptionStep item) throws BuildException, IOException {
        DataSet ds = dd.getDatasets().get(0);
        if (ds.isReference()) {
            DataSetManager.loadReferences(ddImpl, ds);
        } else {
            DataSetManager.createDataSetImpl(ddImpl, ds, item);
        }
        ImplementationsContainer.getInstance().addDataDescription(item, ddImpl);
    }

    private static void loadMultiDataset(DataDescriptionImpl ddImpl, DataDescription dd, DataDescriptionStep item) throws BuildException, IOException {
        if (!ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
            throw new BuildException(AntMessage.JEMA008E.toMessage().getFormattedMessage(dd.getName(), dd.getDisposition()));
        }
        for (DataSet ds : dd.getDatasets()) {
            if (ds.isReference()) {
                DataSetManager.loadReferences(ddImpl, ds);
                continue;
            }
            DataSetManager.createDataSetImpl(ddImpl, ds, item);
        }
        ImplementationsContainer.getInstance().addDataDescription(item, ddImpl);
    }
}

