/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.property.LocalProperties;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.catalog.gdg.GDGManager;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.AntBatchSecurityManager;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.DataSet;
import org.pepstock.jem.ant.tasks.Lock;
import org.pepstock.jem.ant.tasks.managers.ImplementationsContainer;

public class WrapperTask
extends Task
implements TaskContainer,
DataDescriptionStep {
    private String id = "1";
    private String name = null;
    private int order = 0;
    private ArrayList<DataDescription> dataDescriptions = new ArrayList();
    private ArrayList<Lock> locks = new ArrayList();
    private Task nestedTask = null;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name == null ? this.getTaskName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public String getTargetName() {
        return this.getOwningTarget().getName();
    }

    public void addDataDescription(DataDescription dd) {
        for (DataSet dataset : dd.getDatasets()) {
            if (!dataset.isInline() || !dataset.isReplaceProperties()) continue;
            String changed = this.getProject().replaceProperties(dataset.getText().toString());
            dataset.setTextBuffer(new StringBuffer(changed));
        }
        this.dataDescriptions.add(dd);
    }

    @Override
    public ArrayList<DataDescription> getDataDescriptions() {
        return this.dataDescriptions;
    }

    public void addLock(Lock lock) {
        this.locks.add(lock);
    }

    @Override
    public ArrayList<Lock> getLocks() {
        return this.locks;
    }

    public void addTask(Task task) {
        if (this.nestedTask != null) {
            throw new BuildException(AntMessage.JEMA052E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.nestedTask = task;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block21: {
            boolean isExecutionStarted = false;
            AntBatchSecurityManager batchSM = (AntBatchSecurityManager)System.getSecurityManager();
            batchSM.setInternalAction(true);
            List<DataDescriptionImpl> ddList = null;
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            LocalProperties localProperties = LocalProperties.get((Project)this.getProject());
            try {
                ddList = ImplementationsContainer.getInstance().getDataDescriptionsByItem(this);
                if (!ddList.isEmpty()) {
                    localProperties.enterScope();
                    for (DataDescriptionImpl ddImpl : ddList) {
                        localProperties.addLocal("DD_" + ddImpl.getName());
                    }
                    for (DataDescriptionImpl ddImpl : ddList) {
                        GDGManager.load(ddImpl);
                        this.log(AntMessage.JEMA034I.toMessage().getFormattedMessage(ddImpl));
                        for (DataSetImpl dataset : ddImpl.getDataSetsImpl()) {
                            propertyHelper.setProperty("DD_" + ddImpl.getName(), (Object)dataset.getRealFile().getAbsolutePath(), true);
                        }
                    }
                }
                batchSM.setInternalAction(false);
                isExecutionStarted = true;
                this.nestedTask.perform();
                batchSM.setInternalAction(true);
                if (ddList == null || ddList.isEmpty()) break block21;
            }
            catch (BuildException e1) {
                try {
                    throw e1;
                    catch (RemoteException e) {
                        throw new BuildException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    batchSM.setInternalAction(true);
                    if (ddList != null && !ddList.isEmpty()) {
                        localProperties.exitScope();
                        StringBuffer exceptions = new StringBuffer();
                        for (DataDescriptionImpl ddImpl : ddList) {
                            try {
                                if (!isExecutionStarted) continue;
                                GDGManager.store(ddImpl);
                            }
                            catch (IOException e) {
                                this.log(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                                if (exceptions.length() == 0) {
                                    exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                                    continue;
                                }
                                exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                            }
                        }
                        if (exceptions.length() > 0) {
                            throw new BuildException(exceptions.toString());
                        }
                    }
                    throw throwable;
                }
            }
            localProperties.exitScope();
            StringBuffer exceptions = new StringBuffer();
            for (DataDescriptionImpl ddImpl : ddList) {
                try {
                    if (!isExecutionStarted) continue;
                    GDGManager.store(ddImpl);
                }
                catch (IOException e) {
                    this.log(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                    if (exceptions.length() == 0) {
                        exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                        continue;
                    }
                    exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                }
            }
            if (exceptions.length() > 0) {
                throw new BuildException(exceptions.toString());
            }
        }
    }
}

