/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks;

import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.pepstock.jem.Step;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.AntBatchSecurityManager;
import org.pepstock.jem.ant.tasks.Procedure;
import org.pepstock.jem.ant.tasks.ProcedureDefinition;
import org.pepstock.jem.ant.tasks.managers.Locker;
import org.pepstock.jem.ant.tasks.managers.ProceduresContainer;
import org.pepstock.jem.ant.tasks.managers.ReturnCodesContainer;
import org.pepstock.jem.ant.tasks.managers.StepsContainer;
import org.pepstock.jem.node.rmi.TasksDoor;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.rmi.RegistryLocator;

public class StepListener
implements BuildListener {
    private static final int MAX_TASKS_FOR_TARGET = 100;
    private int stepOrder = 100;
    private TasksDoor door = null;
    private boolean isFirst = true;
    private String lockingScope = "job";
    private Locker locker = null;

    public StepListener() {
        ReturnCodesContainer.getInstance();
    }

    public void buildStarted(BuildEvent event) {
        if (this.door == null) {
            String port = System.getProperty("jem.rmi.port");
            try {
                Collection<Role> myroles;
                RegistryLocator locator = new RegistryLocator(Parser.parseInt(port, -1));
                if (locator.hasRmiObject("TASKS_DOOR")) {
                    this.door = (TasksDoor)locator.getRmiObject("TASKS_DOOR");
                    myroles = this.door.setJobStarted(ManagementFactory.getRuntimeMXBean().getName());
                    if (System.getSecurityManager() != null) {
                        throw new Exception(AntMessage.JEMA039E.toMessage().getMessage());
                    }
                } else {
                    throw new Exception(AntMessage.JEMA038E.toMessage().getFormattedMessage("TASKS_DOOR"));
                }
                System.setSecurityManager(new AntBatchSecurityManager(myroles));
                this.locker = new Locker();
            }
            catch (Exception e) {
                throw new BuildException(AntMessage.JEMA040E.toMessage().getFormattedMessage(e.getMessage()), (Throwable)e);
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        System.out.flush();
        System.err.flush();
        AntBatchSecurityManager batchSM = (AntBatchSecurityManager)System.getSecurityManager();
        batchSM.setInternalAction(true);
        try {
            this.door.setJobEnded();
            if (this.isJobLockingScope()) {
                this.locker.unlock();
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            batchSM.setInternalAction(false);
        }
    }

    public void targetStarted(BuildEvent event) {
        if (this.isFirst) {
            this.setLockingScope(event.getProject());
            event.getProject().log(AntMessage.JEMA033I.toMessage().getFormattedMessage(event.getProject().getName(), this.lockingScope));
            if (this.isJobLockingScope()) {
                this.loadForLock(event.getProject());
                this.checkProcedure();
                try {
                    this.locker.lock();
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            this.isFirst = false;
        }
        if (this.isStepLockingScope()) {
            this.loadForLock(event.getTarget());
            this.checkProcedure();
            try {
                this.locker.lock();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        AntBatchSecurityManager batchSM = (AntBatchSecurityManager)System.getSecurityManager();
        batchSM.setInternalAction(true);
        if (!event.getTarget().getName().equals("")) {
            try {
                Step step = new Step();
                step.setName(event.getTarget().getName());
                step.setDescritpion(event.getTarget().getDescription());
                this.door.setStepStarted(step);
            }
            catch (RemoteException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            finally {
                batchSM.setInternalAction(false);
            }
        }
        batchSM.setInternalAction(false);
    }

    public void targetFinished(BuildEvent event) {
        AntBatchSecurityManager batchSM = (AntBatchSecurityManager)System.getSecurityManager();
        batchSM.setInternalAction(true);
        if (!event.getTarget().getName().equals("")) {
            try {
                Step step = new Step();
                step.setName(event.getTarget().getName());
                step.setDescritpion(event.getTarget().getDescription());
                step.setReturnCode(event.getException() != null ? 1 : 0);
                if (event.getException() != null) {
                    step.setException(event.getException().getMessage());
                }
                this.door.setStepEnded(step);
                if (this.isStepLockingScope()) {
                    this.locker.unlock();
                }
            }
            catch (Exception e) {
                batchSM.setInternalAction(false);
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        batchSM.setInternalAction(false);
    }

    public void taskStarted(BuildEvent event) {
        if (this.isTaskLockingScope()) {
            this.loadForLock(event.getTarget(), event.getTask());
            this.checkProcedure();
            try {
                this.locker.lock();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void taskFinished(BuildEvent event) {
        if (this.isTaskLockingScope()) {
            try {
                this.locker.unlock();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void messageLogged(BuildEvent event) {
    }

    private boolean isJobLockingScope() {
        return this.lockingScope.equalsIgnoreCase("job");
    }

    private boolean isStepLockingScope() {
        return this.lockingScope.equalsIgnoreCase("step");
    }

    private boolean isTaskLockingScope() {
        return this.lockingScope.equalsIgnoreCase("task");
    }

    private void setLockingScope(Project project) {
        String lockingScopeProperty = project.getProperty("jem.job.lockingScope");
        if (lockingScopeProperty == null) {
            return;
        }
        if (!(lockingScopeProperty.equalsIgnoreCase("job") || lockingScopeProperty.equalsIgnoreCase("step") || lockingScopeProperty.equalsIgnoreCase("task"))) {
            throw new BuildException(AntMessage.JEMA032E.toMessage().getFormattedMessage("jem.job.lockingScope", lockingScopeProperty));
        }
        this.lockingScope = lockingScopeProperty.toLowerCase();
    }

    private void loadForLock(Project project) {
        Map mm = project.getCopyOfReferences();
        AntXMLContext context = (AntXMLContext)mm.get("ant.parsing.context");
        Iterator i$ = context.getTargets().iterator();
        while (i$.hasNext()) {
            Target obj;
            Target target = obj = (Target)i$.next();
            this.loadForLock(target);
            this.stepOrder += 100;
        }
    }

    private void loadForLock(Target target) {
        Task[] tasks = target.getTasks();
        if (tasks != null && tasks.length > 0) {
            for (int i = 0; i < tasks.length; ++i) {
                this.loadForLock(target, tasks[i], this.stepOrder + i);
            }
        }
    }

    private void loadForLock(Target target, Task task) {
        this.loadForLock(target, task, 0);
    }

    private void loadForLock(Target target, Task task, int order) {
        if (task instanceof UnknownElement) {
            UnknownElement uePre = (UnknownElement)task;
            try {
                UnknownElement ue = (UnknownElement)uePre.clone();
                ue.maybeConfigure();
                if (ue.getTask() instanceof DataDescriptionStep) {
                    DataDescriptionStep item = (DataDescriptionStep)ue.getTask();
                    item.setOrder(order);
                    StepsContainer.getInstance().getDataDescriptionSteps().add(item);
                } else if (ue.getTask() instanceof Procedure) {
                    Procedure proc = (Procedure)ue.getTask();
                    proc.setOrder(order);
                    ProceduresContainer.getInstance().getProcedures().add(proc);
                } else if (ue.getRealThing() instanceof ProcedureDefinition) {
                    ProcedureDefinition def = (ProcedureDefinition)((Object)ue.getRealThing());
                    ProceduresContainer.getInstance().getProceduresDefinitions().put(def.getName(), def);
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkProcedure() {
        if (ProceduresContainer.getInstance().getProcedures().isEmpty()) {
            return;
        }
        for (Procedure proc : ProceduresContainer.getInstance().getProcedures()) {
            if (proc.getName() == null) continue;
            ProcedureDefinition pd = ProceduresContainer.getInstance().getProceduresDefinitions().get(proc.getName());
            proc.setDefinition(pd);
            proc.loadDefinedTask();
            proc.ovverrideDefinedTask();
            for (Task task : proc.getDefinedTasks()) {
                if (!(task instanceof DataDescriptionStep)) continue;
                DataDescriptionStep item = (DataDescriptionStep)task;
                item.setOrder(proc.getOrder());
                StepsContainer.getInstance().getDataDescriptionSteps().add(item);
            }
        }
    }
}

