/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.catalog.gdg.GDGManager;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.AntBatchSecurityManager;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.DataSet;
import org.pepstock.jem.ant.tasks.Lock;
import org.pepstock.jem.ant.tasks.managers.ImplementationsContainer;
import org.pepstock.jem.ant.tasks.managers.ReturnCodesContainer;
import org.pepstock.jem.util.Parser;

public class StepExec
extends ExecTask
implements DataDescriptionStep {
    public static final String DD_PREFIX = "DD_";
    private String id = "1";
    private String name = null;
    private int order = 0;
    private static final String RESULT_KEY = "s";
    private ArrayList<DataDescription> dataDescriptions = new ArrayList();
    private ArrayList<Lock> locks = new ArrayList();
    private int returnCode = 0;

    public StepExec() {
        super.setFailonerror(false);
        super.setFailIfExecutionFails(true);
        super.setResultProperty(RESULT_KEY);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name == null ? this.getTaskName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public String getTargetName() {
        return this.getOwningTarget().getName();
    }

    public void addDataDescription(DataDescription dd) {
        for (DataSet dataset : dd.getDatasets()) {
            if (!dataset.isInline() || !dataset.isReplaceProperties()) continue;
            String changed = this.getProject().replaceProperties(dataset.getText().toString());
            dataset.setTextBuffer(new StringBuffer(changed));
        }
        this.dataDescriptions.add(dd);
    }

    @Override
    public ArrayList<DataDescription> getDataDescriptions() {
        return this.dataDescriptions;
    }

    public void addLock(Lock lock) {
        this.locks.add(lock);
    }

    @Override
    public ArrayList<Lock> getLocks() {
        return this.locks;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        System.out.println("Ecco: " + PropertyHelper.getPropertyHelper((Project)this.getProject()).getProperties());
        boolean isExecutionStarted = false;
        AntBatchSecurityManager batchSM = (AntBatchSecurityManager)System.getSecurityManager();
        batchSM.setInternalAction(true);
        List<DataDescriptionImpl> ddList = null;
        try {
            ddList = ImplementationsContainer.getInstance().getDataDescriptionsByItem(this);
            if (!ddList.isEmpty()) {
                for (DataDescriptionImpl ddImpl : ddList) {
                    GDGManager.load(ddImpl);
                    this.log(AntMessage.JEMA034I.toMessage().getFormattedMessage(ddImpl));
                    for (DataSetImpl dataset : ddImpl.getDataSetsImpl()) {
                        this.addEnvVariable(ddImpl.getName(), dataset.getRealFile());
                    }
                }
            }
            batchSM.setInternalAction(false);
            isExecutionStarted = true;
            super.execute();
        }
        catch (BuildException e1) {
            try {
                this.returnCode = 1;
                throw e1;
                catch (RemoteException e) {
                    this.returnCode = 1;
                    throw new BuildException((Throwable)e);
                }
                catch (IOException e) {
                    this.returnCode = 1;
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object rcObject = PropertyHelper.getPropertyHelper((Project)this.getProject()).getProperty(RESULT_KEY);
                if (rcObject != null) {
                    this.returnCode = Parser.parseInt(rcObject.toString(), 0);
                }
                ReturnCodesContainer.getInstance().setReturnCode(this.getProject(), this, this.returnCode);
                this.getProject().setProperty("Eccome", "ecco");
                batchSM.setInternalAction(true);
                if (ddList != null && !ddList.isEmpty()) {
                    StringBuffer exceptions = new StringBuffer();
                    for (DataDescriptionImpl ddImpl : ddList) {
                        try {
                            if (!isExecutionStarted) continue;
                            GDGManager.store(ddImpl);
                        }
                        catch (IOException e) {
                            this.log(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                            if (exceptions.length() == 0) {
                                exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                                continue;
                            }
                            exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                        }
                    }
                    if (exceptions.length() > 0) {
                        throw new BuildException(exceptions.toString());
                    }
                }
                throw throwable;
            }
        }
        Object rcObject = PropertyHelper.getPropertyHelper((Project)this.getProject()).getProperty(RESULT_KEY);
        if (rcObject != null) {
            this.returnCode = Parser.parseInt(rcObject.toString(), 0);
        }
        ReturnCodesContainer.getInstance().setReturnCode(this.getProject(), this, this.returnCode);
        this.getProject().setProperty("Eccome", "ecco");
        batchSM.setInternalAction(true);
        if (ddList != null && !ddList.isEmpty()) {
            StringBuffer exceptions = new StringBuffer();
            for (DataDescriptionImpl ddImpl : ddList) {
                try {
                    if (!isExecutionStarted) continue;
                    GDGManager.store(ddImpl);
                }
                catch (IOException e) {
                    this.log(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                    if (exceptions.length() == 0) {
                        exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage()));
                        continue;
                    }
                    exceptions.append(AntMessage.JEMA036E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                }
            }
            if (exceptions.length() > 0) {
                throw new BuildException(exceptions.toString());
            }
        }
    }

    private void addEnvVariable(String key, File file) {
        if (file == null) {
            return;
        }
        if (key == null) {
            return;
        }
        Environment.Variable var = new Environment.Variable();
        var.setKey(DD_PREFIX + key);
        var.setValue(file.getAbsolutePath());
        super.addEnv(var);
    }
}

