/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.property.LocalProperties;
import org.apache.tools.ant.taskdefs.Sequential;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.DataDescriptionStep;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.ProcedureDefinition;

public class Procedure
extends Task
implements TaskContainer {
    private String name = null;
    private int order = 0;
    private ProcedureDefinition definition = null;
    private LinkedList<Task> definedTasks = new LinkedList();
    private ArrayList<Task> nestedTasks = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ProcedureDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ProcedureDefinition definition) {
        this.definition = definition;
    }

    public void loadDefinedTask() {
        if (this.definition == null) {
            return;
        }
        UnknownElement nt = this.definition.getNestedTask();
        nt.maybeConfigure();
        if (nt.getTask() instanceof Sequential) {
            for (UnknownElement child : nt.getChildren()) {
                if (!(child instanceof UnknownElement)) continue;
                UnknownElement childElement = child;
                childElement.maybeConfigure();
                try {
                    Task task = (Task)childElement.getTask().clone();
                    this.addDefinedTask(task);
                }
                catch (CloneNotSupportedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        } else {
            try {
                Task task = (Task)nt.getTask().clone();
                this.addDefinedTask(task);
            }
            catch (CloneNotSupportedException e) {
                throw new BuildException((Throwable)e);
            }
        }
        for (Task object : this.nestedTasks) {
            if (!(object instanceof UnknownElement)) continue;
            UnknownElement nested = (UnknownElement)object;
            nested.maybeConfigure();
        }
    }

    public void ovverrideDefinedTask() {
        for (Task object : this.nestedTasks) {
            UnknownElement nested = (UnknownElement)object;
            Task nestedTask = nested.getTask();
            if (this.checkAndLoadNestedtask(nestedTask)) continue;
            throw new BuildException(AntMessage.JEMA024E.toMessage().getFormattedMessage(nestedTask.getTaskName(), this.getName()));
        }
    }

    private boolean checkAndLoadNestedtask(Task nestedTask) {
        for (Task task : this.definedTasks) {
            if (!task.getTaskName().equalsIgnoreCase(nestedTask.getTaskName()) || !(task instanceof DataDescriptionStep) || !(nestedTask instanceof DataDescriptionStep)) continue;
            DataDescriptionStep taskStep = (DataDescriptionStep)task;
            DataDescriptionStep nestedTaskStep = (DataDescriptionStep)nestedTask;
            if (!taskStep.getName().equalsIgnoreCase(nestedTaskStep.getName())) continue;
            for (DataDescription nestedTaskDD : nestedTaskStep.getDataDescriptions()) {
                Iterator<DataDescription> iterTask = taskStep.getDataDescriptions().iterator();
                while (iterTask.hasNext()) {
                    DataDescription dd = iterTask.next();
                    if (!dd.getName().equalsIgnoreCase(nestedTaskDD.getName())) continue;
                    iterTask.remove();
                }
            }
            taskStep.getDataDescriptions().addAll(nestedTaskStep.getDataDescriptions());
            taskStep.getLocks().addAll(nestedTaskStep.getLocks());
            taskStep.setId(nestedTaskStep.getId());
            return true;
        }
        return false;
    }

    private void addDefinedTask(Task definedTask) {
        this.definedTasks.add(definedTask);
        definedTask.setOwningTarget(this.getOwningTarget());
    }

    public LinkedList<Task> getDefinedTasks() {
        return this.definedTasks;
    }

    public ArrayList<Task> getNestedTasks() {
        return this.nestedTasks;
    }

    public void addTask(Task nestedTask) {
        this.nestedTasks.add(nestedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        LocalProperties localProperties = LocalProperties.get((Project)this.getProject());
        localProperties.enterScope();
        try {
            for (Task definedTask : this.definedTasks) {
                definedTask.perform();
            }
        }
        finally {
            localProperties.exitScope();
        }
    }
}

