/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant.tasks;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.pepstock.catalog.gdg.GDGUtil;
import org.pepstock.jem.ant.AntMessage;

public class DataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private int offset = Integer.MIN_VALUE;
    private StringBuffer textBuffer = new StringBuffer();
    private String datasource = null;
    private boolean replaceProperties = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.trim().length() == 0) {
            throw new BuildException(AntMessage.JEMA041E.toMessage().getFormattedMessage(new Object[0]));
        }
        try {
            Object[] objects = GDGUtil.isGDG(name);
            this.name = objects[0].toString();
            this.offset = Integer.parseInt(objects[1].toString());
        }
        catch (ParseException e) {
            this.name = name;
            this.offset = Integer.MIN_VALUE;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isTemporary() {
        if (this.name != null) {
            return this.name.startsWith("@@") && !this.isInline();
        }
        return false;
    }

    public boolean isReference() {
        if (this.name != null) {
            return this.name.startsWith("*.") && !this.isInline();
        }
        return false;
    }

    public void setTextBuffer(StringBuffer textBuffer) {
        this.textBuffer = textBuffer;
    }

    public void addText(String text) {
        this.textBuffer.append(text);
    }

    public StringBuffer getText() {
        return this.textBuffer;
    }

    public boolean isInline() {
        return this.textBuffer.length() > 0;
    }

    public boolean isGdg() {
        return this.offset != Integer.MIN_VALUE && !this.isDatasource();
    }

    public boolean isDatasource() {
        return this.datasource != null;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String resource) {
        if (resource.trim().length() == 0) {
            throw new BuildException(AntMessage.JEMA020E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.datasource = resource;
    }

    public boolean isReplaceProperties() {
        return this.replaceProperties;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public String toString() {
        if (this.isInline()) {
            return "content=" + this.textBuffer.toString();
        }
        return "dsn=" + this.name;
    }
}

