/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant;

import java.io.File;
import org.apache.tools.ant.launch.Launcher;
import org.pepstock.jem.Job;
import org.pepstock.jem.ant.AntJcl;
import org.pepstock.jem.ant.tasks.StepListener;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.DefaultJobTask;
import org.pepstock.jem.node.tasks.JavaUtils;
import org.pepstock.jem.node.tasks.shell.JavaCommand;

public class AntTask
extends DefaultJobTask {
    private static final long serialVersionUID = -1L;
    private static final String[] FOLDER = new String[]{"ant"};
    boolean useSU = false;

    public AntTask(Job job, JemFactory factory) {
        super(job, factory);
    }

    @Override
    public void configure() throws Exception {
        super.configure();
        String currentClassPath = JavaUtils.getClassPath(FOLDER);
        this.getEnv().put("CLASSPATH", currentClassPath);
        Job job = this.getJob();
        File jclFile = Main.OUTPUT_SYSTEM.getJclFile(job);
        AntJcl jcl = (AntJcl)job.getJcl();
        if (jcl.getClassPath() != null) {
            currentClassPath = currentClassPath + File.pathSeparator + jcl.getClassPath();
            this.getEnv().put("CLASSPATH", currentClassPath);
        }
        JavaCommand jCommand = this.getCommand();
        jCommand.setClassPath(currentClassPath);
        jCommand.setClassName(Launcher.class.getName());
        jCommand.setClassArguments("-f", jclFile.getAbsolutePath(), "-listener", StepListener.class.getName());
    }
}

