/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.xml.bind.ValidationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.ant.AntJcl;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.AntTask;
import org.pepstock.jem.ant.validator.transformer.TransformerValidator;
import org.pepstock.jem.factories.AbstractFactory;
import org.pepstock.jem.factories.JclFactoryException;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.JobTask;
import org.pepstock.jem.util.Parser;

public class AntFactory
extends AbstractFactory {
    private static final long serialVersionUID = 1L;
    public static final String ANT_TYPE = "ant";
    private static final String ANT_TYPE_DESCRIPTION = "Apache ANT";
    private static final String ANT_BASE_DIR = ".";
    private transient TransformerValidator validator = null;

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        String xsltvalidatorFile = this.getProperties().getProperty("jem.xslt.project.validator");
        if (xsltvalidatorFile != null && !xsltvalidatorFile.isEmpty()) {
            if (this.validator == null) {
                this.validator = new TransformerValidator();
            }
            this.validator.load(xsltvalidatorFile);
        }
    }

    @Override
    public Jcl createJcl(String content) throws JclFactoryException {
        AntJcl jcl = new AntJcl();
        jcl.setType(ANT_TYPE);
        jcl.setContent(content);
        File file = null;
        try {
            file = File.createTempFile("jcl", ".jcl");
            PrintStream writer = new PrintStream(new FileOutputStream(file));
            writer.print(jcl.getContent());
            writer.flush();
            writer.close();
            this.validate(jcl, file);
        }
        catch (Exception e) {
            JclFactoryException jfe = new JclFactoryException(e);
            jfe.setJcl(jcl);
            throw jfe;
        }
        finally {
            boolean isDeleted;
            if (file == null || !(isDeleted = file.delete())) {
                // empty if block
            }
        }
        return jcl;
    }

    private void validate(AntJcl jcl, File file) throws Exception {
        String classPath;
        String user;
        String affinity;
        String emailAddresses;
        String domain;
        String jobName;
        Project p = new Project();
        p.initProperties();
        p.setBasedir(ANT_BASE_DIR);
        p.setUserProperty("ant.file", file.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        try {
            helper.parse(p, (Object)file);
        }
        catch (BuildException ex) {
            String jobName2 = p.getName() != null ? p.getName() : p.getProperty("jem.job.name");
            jcl.setJobName(jobName2);
            throw ex;
        }
        String string = jobName = p.getName() != null ? p.getName() : p.getProperty("jem.job.name");
        if (jobName == null) {
            throw new ValidationException(AntMessage.JEMA031E.toMessage().getFormattedMessage(new Object[0]));
        }
        String lockingScopeProperty = p.getProperty("jem.job.lockingScope");
        if (!(lockingScopeProperty == null || lockingScopeProperty.equalsIgnoreCase("job") || lockingScopeProperty.equalsIgnoreCase("step") || lockingScopeProperty.equalsIgnoreCase("task"))) {
            throw new ValidationException(AntMessage.JEMA032E.toMessage().getFormattedMessage("jem.job.lockingScope", lockingScopeProperty));
        }
        String environment = p.getProperty("jem.job.environment");
        if (environment == null) {
            environment = Main.EXECUTION_ENVIRONMENT.getEnvironment();
        }
        if ((domain = p.getProperty("jem.job.domain")) == null) {
            domain = "***";
        }
        if (null != (emailAddresses = p.getProperty("jem.job.emailsNotification"))) {
            jcl.setEmailNotificationAddresses(emailAddresses);
        }
        if ((affinity = p.getProperty("jem.job.affinity")) == null) {
            affinity = "***";
        }
        if (null != (user = p.getProperty("jem.job.user"))) {
            jcl.setUser(user);
        }
        if ((classPath = p.getProperty("jem.job.classPath")) != null) {
            jcl.setClassPath(super.resolvePathNames(classPath, "jem.classpath"));
        }
        int memory = Parser.parseInt(p.getProperty("jem.job.memory"), 128);
        boolean hold = Parser.parseBoolean(p.getProperty("jem.job.hold"), false);
        int priority = Parser.parseInt(p.getProperty("jem.job.priority"), 10);
        jcl.setJobName(jobName);
        jcl.setEnvironment(environment);
        jcl.setDomain(domain);
        jcl.setAffinity(affinity);
        jcl.setHold(hold);
        jcl.setPriority(priority);
        jcl.setMemory(memory);
        if (this.validator != null) {
            try {
                this.validator.validate(jcl);
            }
            catch (ValidationException e) {
                throw new ValidationException(AntMessage.JEMA047E.toMessage().getFormattedMessage(e.getMessage()));
            }
        }
    }

    @Override
    public JobTask createJobTask(Job job) {
        return new AntTask(job, this);
    }

    @Override
    public String getType() {
        return ANT_TYPE;
    }

    @Override
    public String getTypeDescription() {
        return ANT_TYPE_DESCRIPTION;
    }
}

