/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.catalog.gdg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.pepstock.catalog.gdg.GDGMessage;

public class Root {
    public static final String LAST_GENERATION_PROPERTY = "jem.last.generation";
    public static final String ROOT_FILE_NAME = "root.properties";
    private File file = null;
    private int lastVersion = 0;
    private Properties properties = new Properties();

    public Root(File parent) throws IOException {
        this(parent, true);
    }

    protected Root(File parent, boolean load) throws IOException {
        if (parent == null) {
            throw new FileNotFoundException(GDGMessage.JEMD006E.toMessage().getMessage());
        }
        if (!parent.exists()) {
            throw new FileNotFoundException(GDGMessage.JEMD010E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
        }
        if (!parent.isDirectory()) {
            throw new FileNotFoundException(GDGMessage.JEMD011E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
        }
        this.file = new File(parent, ROOT_FILE_NAME);
        if (load) {
            if (!this.file.exists()) {
                throw new FileNotFoundException(GDGMessage.JEMD010E.toMessage().getFormattedMessage(this.file.getAbsolutePath()));
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.file);
                this.properties.load(fis);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            if (this.properties.containsKey(LAST_GENERATION_PROPERTY)) {
                String lastGenStr = this.properties.getProperty(LAST_GENERATION_PROPERTY);
                try {
                    this.lastVersion = Integer.parseInt(lastGenStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(GDGMessage.JEMD012E.toMessage().getFormattedMessage(lastGenStr), nfe);
                }
            } else {
                throw new IOException(GDGMessage.JEMD013E.toMessage().getMessage());
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(int relative) {
        this.properties.setProperty(LAST_GENERATION_PROPERTY, String.valueOf(this.lastVersion + relative));
    }

    public boolean hasVersion(String key) {
        return this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getVersion(String key) {
        return this.properties.getProperty(key);
    }

    public void setVersion(String key, String version) {
        this.properties.setProperty(key, version);
    }

    public void commit() throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            this.properties.store(fos, "new GDG version");
            fos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

