/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.catalog.gdg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.catalog.gdg.GDGMessage;
import org.pepstock.catalog.gdg.Root;

public class GDGUtil {
    private static final String GDG_FORMAT = "{0}({1,number,integer})";
    private static final String GDG_WITH_PLUS_FORMAT = "{0}(+{1,number,integer})";
    private static MessageFormat FORMAT = new MessageFormat("{0}({1,number,integer})");
    private static MessageFormat FORMAT_WITH_PLUS = new MessageFormat("{0}(+{1,number,integer})");

    public static String getGenerationIndex(Root root, int offset) {
        return GDGUtil.createGenerationIndex(root.getLastVersion(), offset);
    }

    private static String createGenerationIndex(int lastVersion, int offset) {
        int index = lastVersion + offset;
        if (index < 0) {
            throw new IndexOutOfBoundsException(GDGMessage.JEMD005E.toMessage().getFormattedMessage(offset));
        }
        return StringUtils.leftPad((String)String.valueOf(index), (int)5, (String)"0");
    }

    public static Object[] isGDG(String name) throws ParseException {
        Object[] objects = null;
        try {
            objects = FORMAT.parse(name);
        }
        catch (Exception ex) {
            objects = FORMAT_WITH_PLUS.parse(name);
        }
        return objects;
    }

    public static String getGeneration(Root root, int offset) {
        String key = GDGUtil.createGenerationIndex(root.getLastVersion(), offset);
        String generation = null;
        generation = root.hasVersion(key) ? root.getVersion(key) : key;
        return generation;
    }

    public static Root createGDG(File parent) throws IOException {
        return GDGUtil.createGDG(parent, false);
    }

    public static Root createGDG(File parent, boolean createEmptyGeneration) throws IOException {
        if (parent == null) {
            throw new FileNotFoundException(GDGMessage.JEMD006E.toMessage().getMessage());
        }
        if (parent.exists()) {
            throw new FileNotFoundException(GDGMessage.JEMD007E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
        }
        Root root = null;
        if (parent.mkdirs()) {
            root = new Root(parent, false);
            if (createEmptyGeneration) {
                String key = GDGUtil.getGenerationIndex(root, 0);
                String generation = GDGUtil.getGeneration(root, 0);
                File newFile = new File(root.getFile().getParentFile(), generation);
                if (!newFile.createNewFile()) {
                    throw new FileNotFoundException(GDGMessage.JEMD008E.toMessage().getFormattedMessage(newFile.getAbsolutePath()));
                }
                root.setVersion(key, newFile.getName());
            }
        } else {
            throw new FileNotFoundException(GDGMessage.JEMD009E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
        }
        root.setLastVersion(0);
        root.commit();
        return root;
    }
}

