/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.catalog.gdg;

import java.io.File;
import java.io.IOException;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.catalog.gdg.GDGMessage;
import org.pepstock.catalog.gdg.GDGUtil;
import org.pepstock.catalog.gdg.Root;
import org.pepstock.jem.util.Parser;

public class GDGManager {
    public static void load(DataDescriptionImpl ddImpl) throws IOException {
        for (DataSetImpl dataset : ddImpl.getDataSetsImpl()) {
            if (dataset.getType() != 4) continue;
            Root root = new Root(dataset.getFile());
            if (ddImpl.getDataDescriptionReference() != null) {
                File referFile = new File(root.getFile().getParentFile(), dataset.getRealName());
                if (referFile.exists()) continue;
                throw new IOException(GDGMessage.JEMD001E.toMessage().getFormattedMessage(ddImpl.getName(), dataset.getRealName()));
            }
            String key = GDGUtil.getGenerationIndex(root, dataset.getOffset());
            String generation = GDGUtil.getGeneration(root, dataset.getOffset());
            File newFile = new File(root.getFile().getParentFile(), generation);
            if (!ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                if (dataset.getOffset() > 0) {
                    throw new IOException(GDGMessage.JEMD002E.toMessage().getFormattedMessage(ddImpl.getName(), generation, ddImpl.getDisposition()));
                }
                if (!newFile.exists()) {
                    throw new IOException(GDGMessage.JEMD001E.toMessage().getFormattedMessage(ddImpl.getName(), generation));
                }
            } else {
                if (dataset.getOffset() <= 0) {
                    throw new IOException(GDGMessage.JEMD003E.toMessage().getFormattedMessage(ddImpl.getName(), generation));
                }
                if (newFile.exists()) {
                    throw new IOException(GDGMessage.JEMD004E.toMessage().getFormattedMessage(ddImpl.getName(), generation));
                }
            }
            dataset.setKey(key);
            dataset.setRealName(generation);
            dataset.setRealFile(newFile);
        }
    }

    public static void store(DataDescriptionImpl ddImpl) throws IOException {
        for (DataSetImpl dataset : ddImpl.getDataSetsImpl()) {
            if (dataset.getType() != 4) continue;
            Root root = new Root(dataset.getFile());
            if (!dataset.hasRealName()) continue;
            if (dataset.getOffset() > 0 && ddImpl.getDataDescriptionReference() == null) {
                String lastVersionKey;
                if (!dataset.getRealFile().exists()) continue;
                String key = dataset.getKey();
                if (key.compareTo(lastVersionKey = GDGUtil.getGenerationIndex(root, 0)) > 0) {
                    int newOffset = Parser.parseInt(key) - Parser.parseInt(lastVersionKey);
                    root.setLastVersion(newOffset);
                }
                root.setVersion(key, dataset.getRealName());
                root.commit();
                continue;
            }
            if (root.hasVersion(dataset.getKey())) {
                String savedVersion = root.getVersion(dataset.getKey());
                if (savedVersion.equalsIgnoreCase(dataset.getRealName())) continue;
                root.setVersion(dataset.getKey(), dataset.getRealName());
                root.commit();
                continue;
            }
            root.setVersion(dataset.getKey(), dataset.getRealName());
            root.commit();
        }
    }
}

