/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.swarm.executors;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.IdGenerator;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import org.pepstock.jem.Job;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.commands.util.Factory;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;

public class RouterIn
implements Callable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Job job = null;
    private String routingEnvironment = null;

    public RouterIn(Job job, String routingEnvironment) {
        this.job = job;
        this.routingEnvironment = routingEnvironment;
    }

    @Override
    public Boolean call() throws Exception {
        HazelcastInstance hazelcastInstance = SharedObjects.getInstance().getLocalMember();
        if (hazelcastInstance == null || !hazelcastInstance.getLifecycleService().isRunning()) {
            throw new Exception(SwarmNodeMessage.JEMO008E.toMessage().getFormattedMessage(new Object[]{this.job}));
        }
        this.job.getRoutingInfo().setId(this.job.getId());
        this.job.getRoutingInfo().setRoutedTime(new Date());
        this.job.getRoutingInfo().setSubmittedTime(this.job.getSubmittedTime());
        this.job.getRoutingInfo().setEnvironment(this.routingEnvironment);
        PreJob preJob = new PreJob();
        preJob.setJclContent(this.job.getJcl().getContent());
        preJob.setJclType(this.job.getJcl().getType());
        IdGenerator generator = SharedObjects.getInstance().getLocalMember().getIdGenerator("org.pepstock.jem.job.id");
        long id = generator.newId();
        String jobId = Factory.createJobId((Job)this.job, (long)id);
        this.job.setId(jobId);
        preJob.setJob(this.job);
        IQueue jclCheckingQueue = hazelcastInstance.getQueue("org.pepstock.jem.jcl.checking");
        jclCheckingQueue.put((Object)preJob);
        return true;
    }
}

